% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_disassociate_web_acl}
\alias{wafregional_disassociate_web_acl}
\title{Removes a web ACL from the specified resource, either an application
load balancer or Amazon API Gateway stage}
\usage{
wafregional_disassociate_web_acl(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The ARN (Amazon Resource Name) of the resource from which the web ACL is
being removed, either an application load balancer or Amazon API Gateway
stage.

The ARN should be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\code{arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> }
\item For an Amazon API Gateway stage:
\code{arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> }
}}
}
\description{
Removes a web ACL from the specified resource, either an application
load balancer or Amazon API Gateway stage.
}
\section{Request syntax}{
\preformatted{svc$disassociate_web_acl(
  ResourceArn = "string"
)
}
}

\keyword{internal}
