% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_get_user_attribute_verification_code}
\alias{cognitoidentityprovider_get_user_attribute_verification_code}
\title{Gets the user attribute verification code for the specified attribute
name}
\usage{
cognitoidentityprovider_get_user_attribute_verification_code(
  AccessToken, AttributeName, ClientMetadata)
}
\arguments{
\item{AccessToken}{[required] The access token returned by the server response to get the user
attribute verification code.}

\item{AttributeName}{[required] The attribute name returned by the server response to get the user
attribute verification code.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the GetUserAttributeVerificationCode API
action, Amazon Cognito invokes the function that is assigned to the
\emph{custom message} trigger. When Amazon Cognito invokes this function, it
passes a JSON payload, which the function receives as input. This
payload contains a \code{clientMetadata} attribute, which provides the data
that you assigned to the ClientMetadata parameter in your
GetUserAttributeVerificationCode request. In your function code in AWS
Lambda, you can process the \code{clientMetadata} value to enhance your
workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}
}
\description{
Gets the user attribute verification code for the specified attribute
name.
}
\section{Request syntax}{
\preformatted{svc$get_user_attribute_verification_code(
  AccessToken = "string",
  AttributeName = "string",
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
