% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_put_role_permissions_boundary}
\alias{iam_put_role_permissions_boundary}
\title{Adds or updates the policy that is specified as the IAM role's
permissions boundary}
\usage{
iam_put_role_permissions_boundary(RoleName, PermissionsBoundary)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) of the IAM role for which you want to
set the permissions boundary.}

\item{PermissionsBoundary}{[required] The ARN of the policy that is used to set the permissions boundary for
the role.}
}
\description{
Adds or updates the policy that is specified as the IAM role's
permissions boundary. You can use an AWS managed policy or a customer
managed policy to set the boundary for a role. Use the boundary to
control the maximum permissions that the role can have. Setting a
permissions boundary is an advanced feature that can affect the
permissions for the role.

You cannot set the boundary for a service-linked role.

Policies used as permissions boundaries do not provide permissions. You
must also attach a permissions policy to the role. To learn how the
effective permissions for a role are evaluated, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html}{IAM JSON Policy Evaluation Logic}
in the IAM User Guide.
}
\section{Request syntax}{
\preformatted{svc$put_role_permissions_boundary(
  RoleName = "string",
  PermissionsBoundary = "string"
)
}
}

\keyword{internal}
