% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_tag_user}
\alias{iam_tag_user}
\title{Adds one or more tags to an IAM user}
\usage{
iam_tag_user(UserName, Tags)
}
\arguments{
\item{UserName}{[required] The name of the user that you want to add tags to.

This parameter accepts (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that consist of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: =,.@-}

\item{Tags}{[required] The list of tags that you want to attach to the user. Each tag consists
of a key name and an associated value.}
}
\description{
Adds one or more tags to an IAM user. If a tag with the same key name
already exists, then that tag is overwritten with the new value.

A tag consists of a key name and an associated value. By assigning tags
to your resources, you can do the following:
\itemize{
\item \strong{Administrative grouping and discovery} - Attach tags to resources
to aid in organization and search. For example, you could search for
all resources with the key name \emph{Project} and the value
\emph{MyImportantProject}. Or search for all resources with the key name
\emph{Cost Center} and the value \emph{41200}.
\item \strong{Access control} - Reference tags in IAM user-based and
resource-based policies. You can use tags to restrict access to only
an IAM requesting user or to a role that has a specified tag
attached. You can also restrict access to only those resources that
have a certain tag attached. For examples of policies that show how
to use tags to control access, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Control Access Using IAM Tags}
in the \emph{IAM User Guide}.
\item \strong{Cost allocation} - Use tags to help track which individuals and
teams are using which AWS resources.
}<!-- -->

\itemize{
\item Make sure that you have no invalid tags and that you do not exceed
the allowed number of tags per role. In either case, the entire
request fails and \emph{no} tags are added to the role.
\item AWS always interprets the tag \code{Value} as a single string. If you
need to store an array, you can store comma-separated values in the
string. However, you must interpret the value in your code.
}

For more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM Identities}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_user(
  UserName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following example shows how to add tags to an existing user.
svc$tag_user(
  Tags = list(
    list(
      Key = "Dept",
      Value = "Accounting"
    ),
    list(
      Key = "CostCenter",
      Value = "12345"
    )
  ),
  UserName = "anika"
)
}

}
\keyword{internal}
