% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_enable_security_hub}
\alias{securityhub_enable_security_hub}
\title{Enables Security Hub for your account in the current Region or the
Region you specify in the request}
\usage{
securityhub_enable_security_hub(Tags, EnableDefaultStandards)
}
\arguments{
\item{Tags}{The tags to add to the hub resource when you enable Security Hub.}

\item{EnableDefaultStandards}{Whether to enable the security standards that Security Hub has
designated as automatically enabled. If you do not provide a value for
\code{EnableDefaultStandards}, it is set to \code{true}. To not enable the
automatically enabled standards, set \code{EnableDefaultStandards} to
\code{false}.}
}
\description{
Enables Security Hub for your account in the current Region or the
Region you specify in the request.

When you enable Security Hub, you grant to Security Hub the permissions
necessary to gather findings from other services that are integrated
with Security Hub.

When you use the \code{EnableSecurityHub} operation to enable Security Hub,
you also automatically enable the following standards.
\itemize{
\item CIS AWS Foundations
\item AWS Foundational Security Best Practices
}

You do not enable the Payment Card Industry Data Security Standard (PCI
DSS) standard.

To not enable the automatically enabled standards, set
\code{EnableDefaultStandards} to \code{false}.

After you enable Security Hub, to enable a standard, use the
\verb{<a>BatchEnableStandards</a>} operation. To disable a standard, use
the \verb{<a>BatchDisableStandards</a>} operation.

To learn more, see \href{https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html}{Setting Up AWS Security Hub}
in the \emph{AWS Security Hub User Guide}.
}
\section{Request syntax}{
\preformatted{svc$enable_security_hub(
  Tags = list(
    "string"
  ),
  EnableDefaultStandards = TRUE|FALSE
)
}
}

\keyword{internal}
