% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_get_xss_match_set}
\alias{waf_get_xss_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
waf_get_xss_match_set(XssMatchSetId)
}
\arguments{
\item{XssMatchSetId}{[required] The \code{XssMatchSetId} of the XssMatchSet that you want to get.
\code{XssMatchSetId} is returned by CreateXssMatchSet and by
ListXssMatchSets.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns the XssMatchSet that is specified by \code{XssMatchSetId}.
}
\section{Request syntax}{
\preformatted{svc$get_xss_match_set(
  XssMatchSetId = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the details of an XSS match set with the
# ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$get_xss_match_set(
  XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
