% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_get_findings}
\alias{securityhub_get_findings}
\title{Returns a list of findings that match the specified criteria}
\usage{
securityhub_get_findings(Filters, SortCriteria, NextToken, MaxResults)
}
\arguments{
\item{Filters}{The finding attributes used to define a condition to filter the returned
findings.

You can filter by up to 10 finding attributes. For each attribute, you
can provide up to 20 filter values.

Note that in the available filter fields, \code{WorkflowState} is deprecated.
To search for a finding based on its workflow status, use
\code{WorkflowStatus}.}

\item{SortCriteria}{The finding attributes used to sort the list of returned findings.}

\item{NextToken}{The token that is required for pagination. On your first call to the
\code{\link[=securityhub_get_findings]{get_findings}} operation, set the value of
this parameter to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}

\item{MaxResults}{The maximum number of findings to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Findings = list(
    list(
      SchemaVersion = "string",
      Id = "string",
      ProductArn = "string",
      GeneratorId = "string",
      AwsAccountId = "string",
      Types = list(
        "string"
      ),
      FirstObservedAt = "string",
      LastObservedAt = "string",
      CreatedAt = "string",
      UpdatedAt = "string",
      Severity = list(
        Product = 123.0,
        Label = "INFORMATIONAL"|"LOW"|"MEDIUM"|"HIGH"|"CRITICAL",
        Normalized = 123,
        Original = "string"
      ),
      Confidence = 123,
      Criticality = 123,
      Title = "string",
      Description = "string",
      Remediation = list(
        Recommendation = list(
          Text = "string",
          Url = "string"
        )
      ),
      SourceUrl = "string",
      ProductFields = list(
        "string"
      ),
      UserDefinedFields = list(
        "string"
      ),
      Malware = list(
        list(
          Name = "string",
          Type = "ADWARE"|"BLENDED_THREAT"|"BOTNET_AGENT"|"COIN_MINER"|"EXPLOIT_KIT"|"KEYLOGGER"|"MACRO"|"POTENTIALLY_UNWANTED"|"SPYWARE"|"RANSOMWARE"|"REMOTE_ACCESS"|"ROOTKIT"|"TROJAN"|"VIRUS"|"WORM",
          Path = "string",
          State = "OBSERVED"|"REMOVAL_FAILED"|"REMOVED"
        )
      ),
      Network = list(
        Direction = "IN"|"OUT",
        Protocol = "string",
        OpenPortRange = list(
          Begin = 123,
          End = 123
        ),
        SourceIpV4 = "string",
        SourceIpV6 = "string",
        SourcePort = 123,
        SourceDomain = "string",
        SourceMac = "string",
        DestinationIpV4 = "string",
        DestinationIpV6 = "string",
        DestinationPort = 123,
        DestinationDomain = "string"
      ),
      NetworkPath = list(
        list(
          ComponentId = "string",
          ComponentType = "string",
          Egress = list(
            Protocol = "string",
            Destination = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            ),
            Source = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            )
          ),
          Ingress = list(
            Protocol = "string",
            Destination = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            ),
            Source = list(
              Address = list(
                "string"
              ),
              PortRanges = list(
                list(
                  Begin = 123,
                  End = 123
                )
              )
            )
          )
        )
      ),
      Process = list(
        Name = "string",
        Path = "string",
        Pid = 123,
        ParentPid = 123,
        LaunchedAt = "string",
        TerminatedAt = "string"
      ),
      ThreatIntelIndicators = list(
        list(
          Type = "DOMAIN"|"EMAIL_ADDRESS"|"HASH_MD5"|"HASH_SHA1"|"HASH_SHA256"|"HASH_SHA512"|"IPV4_ADDRESS"|"IPV6_ADDRESS"|"MUTEX"|"PROCESS"|"URL",
          Value = "string",
          Category = "BACKDOOR"|"CARD_STEALER"|"COMMAND_AND_CONTROL"|"DROP_SITE"|"EXPLOIT_SITE"|"KEYLOGGER",
          LastObservedAt = "string",
          Source = "string",
          SourceUrl = "string"
        )
      ),
      Resources = list(
        list(
          Type = "string",
          Id = "string",
          Partition = "aws"|"aws-cn"|"aws-us-gov",
          Region = "string",
          ResourceRole = "string",
          Tags = list(
            "string"
          ),
          Details = list(
            AwsAutoScalingAutoScalingGroup = list(
              LaunchConfigurationName = "string",
              LoadBalancerNames = list(
                "string"
              ),
              HealthCheckType = "string",
              HealthCheckGracePeriod = 123,
              CreatedTime = "string"
            ),
            AwsCodeBuildProject = list(
              EncryptionKey = "string",
              Environment = list(
                Certificate = "string",
                ImagePullCredentialsType = "string",
                RegistryCredential = list(
                  Credential = "string",
                  CredentialProvider = "string"
                ),
                Type = "string"
              ),
              Name = "string",
              Source = list(
                Type = "string",
                Location = "string",
                GitCloneDepth = 123,
                InsecureSsl = TRUE|FALSE
              ),
              ServiceRole = "string",
              VpcConfig = list(
                VpcId = "string",
                Subnets = list(
                  "string"
                ),
                SecurityGroupIds = list(
                  "string"
                )
              )
            ),
            AwsCloudFrontDistribution = list(
              CacheBehaviors = list(
                Items = list(
                  list(
                    ViewerProtocolPolicy = "string"
                  )
                )
              ),
              DefaultCacheBehavior = list(
                ViewerProtocolPolicy = "string"
              ),
              DefaultRootObject = "string",
              DomainName = "string",
              ETag = "string",
              LastModifiedTime = "string",
              Logging = list(
                Bucket = "string",
                Enabled = TRUE|FALSE,
                IncludeCookies = TRUE|FALSE,
                Prefix = "string"
              ),
              Origins = list(
                Items = list(
                  list(
                    DomainName = "string",
                    Id = "string",
                    OriginPath = "string",
                    S3OriginConfig = list(
                      OriginAccessIdentity = "string"
                    )
                  )
                )
              ),
              OriginGroups = list(
                Items = list(
                  list(
                    FailoverCriteria = list(
                      StatusCodes = list(
                        Items = list(
                          123
                        ),
                        Quantity = 123
                      )
                    )
                  )
                )
              ),
              Status = "string",
              WebAclId = "string"
            ),
            AwsEc2Instance = list(
              Type = "string",
              ImageId = "string",
              IpV4Addresses = list(
                "string"
              ),
              IpV6Addresses = list(
                "string"
              ),
              KeyName = "string",
              IamInstanceProfileArn = "string",
              VpcId = "string",
              SubnetId = "string",
              LaunchedAt = "string"
            ),
            AwsEc2NetworkInterface = list(
              Attachment = list(
                AttachTime = "string",
                AttachmentId = "string",
                DeleteOnTermination = TRUE|FALSE,
                DeviceIndex = 123,
                InstanceId = "string",
                InstanceOwnerId = "string",
                Status = "string"
              ),
              NetworkInterfaceId = "string",
              SecurityGroups = list(
                list(
                  GroupName = "string",
                  GroupId = "string"
                )
              ),
              SourceDestCheck = TRUE|FALSE
            ),
            AwsEc2SecurityGroup = list(
              GroupName = "string",
              GroupId = "string",
              OwnerId = "string",
              VpcId = "string",
              IpPermissions = list(
                list(
                  IpProtocol = "string",
                  FromPort = 123,
                  ToPort = 123,
                  UserIdGroupPairs = list(
                    list(
                      GroupId = "string",
                      GroupName = "string",
                      PeeringStatus = "string",
                      UserId = "string",
                      VpcId = "string",
                      VpcPeeringConnectionId = "string"
                    )
                  ),
                  IpRanges = list(
                    list(
                      CidrIp = "string"
                    )
                  ),
                  Ipv6Ranges = list(
                    list(
                      CidrIpv6 = "string"
                    )
                  ),
                  PrefixListIds = list(
                    list(
                      PrefixListId = "string"
                    )
                  )
                )
              ),
              IpPermissionsEgress = list(
                list(
                  IpProtocol = "string",
                  FromPort = 123,
                  ToPort = 123,
                  UserIdGroupPairs = list(
                    list(
                      GroupId = "string",
                      GroupName = "string",
                      PeeringStatus = "string",
                      UserId = "string",
                      VpcId = "string",
                      VpcPeeringConnectionId = "string"
                    )
                  ),
                  IpRanges = list(
                    list(
                      CidrIp = "string"
                    )
                  ),
                  Ipv6Ranges = list(
                    list(
                      CidrIpv6 = "string"
                    )
                  ),
                  PrefixListIds = list(
                    list(
                      PrefixListId = "string"
                    )
                  )
                )
              )
            ),
            AwsEc2Volume = list(
              CreateTime = "string",
              Encrypted = TRUE|FALSE,
              Size = 123,
              SnapshotId = "string",
              Status = "string",
              KmsKeyId = "string",
              Attachments = list(
                list(
                  AttachTime = "string",
                  DeleteOnTermination = TRUE|FALSE,
                  InstanceId = "string",
                  Status = "string"
                )
              )
            ),
            AwsEc2Vpc = list(
              CidrBlockAssociationSet = list(
                list(
                  AssociationId = "string",
                  CidrBlock = "string",
                  CidrBlockState = "string"
                )
              ),
              Ipv6CidrBlockAssociationSet = list(
                list(
                  AssociationId = "string",
                  Ipv6CidrBlock = "string",
                  CidrBlockState = "string"
                )
              ),
              DhcpOptionsId = "string",
              State = "string"
            ),
            AwsEc2Eip = list(
              InstanceId = "string",
              PublicIp = "string",
              AllocationId = "string",
              AssociationId = "string",
              Domain = "string",
              PublicIpv4Pool = "string",
              NetworkBorderGroup = "string",
              NetworkInterfaceId = "string",
              NetworkInterfaceOwnerId = "string",
              PrivateIpAddress = "string"
            ),
            AwsElbv2LoadBalancer = list(
              AvailabilityZones = list(
                list(
                  ZoneName = "string",
                  SubnetId = "string"
                )
              ),
              CanonicalHostedZoneId = "string",
              CreatedTime = "string",
              DNSName = "string",
              IpAddressType = "string",
              Scheme = "string",
              SecurityGroups = list(
                "string"
              ),
              State = list(
                Code = "string",
                Reason = "string"
              ),
              Type = "string",
              VpcId = "string"
            ),
            AwsElasticsearchDomain = list(
              AccessPolicies = "string",
              DomainEndpointOptions = list(
                EnforceHTTPS = TRUE|FALSE,
                TLSSecurityPolicy = "string"
              ),
              DomainId = "string",
              DomainName = "string",
              Endpoint = "string",
              Endpoints = list(
                "string"
              ),
              ElasticsearchVersion = "string",
              EncryptionAtRestOptions = list(
                Enabled = TRUE|FALSE,
                KmsKeyId = "string"
              ),
              NodeToNodeEncryptionOptions = list(
                Enabled = TRUE|FALSE
              ),
              VPCOptions = list(
                AvailabilityZones = list(
                  "string"
                ),
                SecurityGroupIds = list(
                  "string"
                ),
                SubnetIds = list(
                  "string"
                ),
                VPCId = "string"
              )
            ),
            AwsS3Bucket = list(
              OwnerId = "string",
              OwnerName = "string",
              CreatedAt = "string",
              ServerSideEncryptionConfiguration = list(
                Rules = list(
                  list(
                    ApplyServerSideEncryptionByDefault = list(
                      SSEAlgorithm = "string",
                      KMSMasterKeyID = "string"
                    )
                  )
                )
              )
            ),
            AwsS3Object = list(
              LastModified = "string",
              ETag = "string",
              VersionId = "string",
              ContentType = "string",
              ServerSideEncryption = "string",
              SSEKMSKeyId = "string"
            ),
            AwsSecretsManagerSecret = list(
              RotationRules = list(
                AutomaticallyAfterDays = 123
              ),
              RotationOccurredWithinFrequency = TRUE|FALSE,
              KmsKeyId = "string",
              RotationEnabled = TRUE|FALSE,
              RotationLambdaArn = "string",
              Deleted = TRUE|FALSE,
              Name = "string",
              Description = "string"
            ),
            AwsIamAccessKey = list(
              UserName = "string",
              Status = "Active"|"Inactive",
              CreatedAt = "string",
              PrincipalId = "string",
              PrincipalType = "string",
              PrincipalName = "string",
              AccountId = "string",
              AccessKeyId = "string",
              SessionContext = list(
                Attributes = list(
                  MfaAuthenticated = TRUE|FALSE,
                  CreationDate = "string"
                ),
                SessionIssuer = list(
                  Type = "string",
                  PrincipalId = "string",
                  Arn = "string",
                  AccountId = "string",
                  UserName = "string"
                )
              )
            ),
            AwsIamUser = list(
              AttachedManagedPolicies = list(
                list(
                  PolicyName = "string",
                  PolicyArn = "string"
                )
              ),
              CreateDate = "string",
              GroupList = list(
                "string"
              ),
              Path = "string",
              PermissionsBoundary = list(
                PermissionsBoundaryArn = "string",
                PermissionsBoundaryType = "string"
              ),
              UserId = "string",
              UserName = "string",
              UserPolicyList = list(
                list(
                  PolicyName = "string"
                )
              )
            ),
            AwsIamPolicy = list(
              AttachmentCount = 123,
              CreateDate = "string",
              DefaultVersionId = "string",
              Description = "string",
              IsAttachable = TRUE|FALSE,
              Path = "string",
              PermissionsBoundaryUsageCount = 123,
              PolicyId = "string",
              PolicyName = "string",
              PolicyVersionList = list(
                list(
                  VersionId = "string",
                  IsDefaultVersion = TRUE|FALSE,
                  CreateDate = "string"
                )
              ),
              UpdateDate = "string"
            ),
            AwsApiGatewayV2Stage = list(
              CreatedDate = "string",
              Description = "string",
              DefaultRouteSettings = list(
                DetailedMetricsEnabled = TRUE|FALSE,
                LoggingLevel = "string",
                DataTraceEnabled = TRUE|FALSE,
                ThrottlingBurstLimit = 123,
                ThrottlingRateLimit = 123.0
              ),
              DeploymentId = "string",
              LastUpdatedDate = "string",
              RouteSettings = list(
                DetailedMetricsEnabled = TRUE|FALSE,
                LoggingLevel = "string",
                DataTraceEnabled = TRUE|FALSE,
                ThrottlingBurstLimit = 123,
                ThrottlingRateLimit = 123.0
              ),
              StageName = "string",
              StageVariables = list(
                "string"
              ),
              AccessLogSettings = list(
                Format = "string",
                DestinationArn = "string"
              ),
              AutoDeploy = TRUE|FALSE,
              LastDeploymentStatusMessage = "string",
              ApiGatewayManaged = TRUE|FALSE
            ),
            AwsApiGatewayV2Api = list(
              ApiEndpoint = "string",
              ApiId = "string",
              ApiKeySelectionExpression = "string",
              CreatedDate = "string",
              Description = "string",
              Version = "string",
              Name = "string",
              ProtocolType = "string",
              RouteSelectionExpression = "string",
              CorsConfiguration = list(
                AllowOrigins = list(
                  "string"
                ),
                AllowCredentials = TRUE|FALSE,
                ExposeHeaders = list(
                  "string"
                ),
                MaxAge = 123,
                AllowMethods = list(
                  "string"
                ),
                AllowHeaders = list(
                  "string"
                )
              )
            ),
            AwsDynamoDbTable = list(
              AttributeDefinitions = list(
                list(
                  AttributeName = "string",
                  AttributeType = "string"
                )
              ),
              BillingModeSummary = list(
                BillingMode = "string",
                LastUpdateToPayPerRequestDateTime = "string"
              ),
              CreationDateTime = "string",
              GlobalSecondaryIndexes = list(
                list(
                  Backfilling = TRUE|FALSE,
                  IndexArn = "string",
                  IndexName = "string",
                  IndexSizeBytes = 123,
                  IndexStatus = "string",
                  ItemCount = 123,
                  KeySchema = list(
                    list(
                      AttributeName = "string",
                      KeyType = "string"
                    )
                  ),
                  Projection = list(
                    NonKeyAttributes = list(
                      "string"
                    ),
                    ProjectionType = "string"
                  ),
                  ProvisionedThroughput = list(
                    LastDecreaseDateTime = "string",
                    LastIncreaseDateTime = "string",
                    NumberOfDecreasesToday = 123,
                    ReadCapacityUnits = 123,
                    WriteCapacityUnits = 123
                  )
                )
              ),
              GlobalTableVersion = "string",
              ItemCount = 123,
              KeySchema = list(
                list(
                  AttributeName = "string",
                  KeyType = "string"
                )
              ),
              LatestStreamArn = "string",
              LatestStreamLabel = "string",
              LocalSecondaryIndexes = list(
                list(
                  IndexArn = "string",
                  IndexName = "string",
                  KeySchema = list(
                    list(
                      AttributeName = "string",
                      KeyType = "string"
                    )
                  ),
                  Projection = list(
                    NonKeyAttributes = list(
                      "string"
                    ),
                    ProjectionType = "string"
                  )
                )
              ),
              ProvisionedThroughput = list(
                LastDecreaseDateTime = "string",
                LastIncreaseDateTime = "string",
                NumberOfDecreasesToday = 123,
                ReadCapacityUnits = 123,
                WriteCapacityUnits = 123
              ),
              Replicas = list(
                list(
                  GlobalSecondaryIndexes = list(
                    list(
                      IndexName = "string",
                      ProvisionedThroughputOverride = list(
                        ReadCapacityUnits = 123
                      )
                    )
                  ),
                  KmsMasterKeyId = "string",
                  ProvisionedThroughputOverride = list(
                    ReadCapacityUnits = 123
                  ),
                  RegionName = "string",
                  ReplicaStatus = "string",
                  ReplicaStatusDescription = "string"
                )
              ),
              RestoreSummary = list(
                SourceBackupArn = "string",
                SourceTableArn = "string",
                RestoreDateTime = "string",
                RestoreInProgress = TRUE|FALSE
              ),
              SseDescription = list(
                InaccessibleEncryptionDateTime = "string",
                Status = "string",
                SseType = "string",
                KmsMasterKeyArn = "string"
              ),
              StreamSpecification = list(
                StreamEnabled = TRUE|FALSE,
                StreamViewType = "string"
              ),
              TableId = "string",
              TableName = "string",
              TableSizeBytes = 123,
              TableStatus = "string"
            ),
            AwsApiGatewayStage = list(
              DeploymentId = "string",
              ClientCertificateId = "string",
              StageName = "string",
              Description = "string",
              CacheClusterEnabled = TRUE|FALSE,
              CacheClusterSize = "string",
              CacheClusterStatus = "string",
              MethodSettings = list(
                list(
                  MetricsEnabled = TRUE|FALSE,
                  LoggingLevel = "string",
                  DataTraceEnabled = TRUE|FALSE,
                  ThrottlingBurstLimit = 123,
                  ThrottlingRateLimit = 123.0,
                  CachingEnabled = TRUE|FALSE,
                  CacheTtlInSeconds = 123,
                  CacheDataEncrypted = TRUE|FALSE,
                  RequireAuthorizationForCacheControl = TRUE|FALSE,
                  UnauthorizedCacheControlHeaderStrategy = "string",
                  HttpMethod = "string",
                  ResourcePath = "string"
                )
              ),
              Variables = list(
                "string"
              ),
              DocumentationVersion = "string",
              AccessLogSettings = list(
                Format = "string",
                DestinationArn = "string"
              ),
              CanarySettings = list(
                PercentTraffic = 123.0,
                DeploymentId = "string",
                StageVariableOverrides = list(
                  "string"
                ),
                UseStageCache = TRUE|FALSE
              ),
              TracingEnabled = TRUE|FALSE,
              CreatedDate = "string",
              LastUpdatedDate = "string",
              WebAclArn = "string"
            ),
            AwsApiGatewayRestApi = list(
              Id = "string",
              Name = "string",
              Description = "string",
              CreatedDate = "string",
              Version = "string",
              BinaryMediaTypes = list(
                "string"
              ),
              MinimumCompressionSize = 123,
              ApiKeySource = "string",
              EndpointConfiguration = list(
                Types = list(
                  "string"
                )
              )
            ),
            AwsCloudTrailTrail = list(
              CloudWatchLogsLogGroupArn = "string",
              CloudWatchLogsRoleArn = "string",
              HasCustomEventSelectors = TRUE|FALSE,
              HomeRegion = "string",
              IncludeGlobalServiceEvents = TRUE|FALSE,
              IsMultiRegionTrail = TRUE|FALSE,
              IsOrganizationTrail = TRUE|FALSE,
              KmsKeyId = "string",
              LogFileValidationEnabled = TRUE|FALSE,
              Name = "string",
              S3BucketName = "string",
              S3KeyPrefix = "string",
              SnsTopicArn = "string",
              SnsTopicName = "string",
              TrailArn = "string"
            ),
            AwsCertificateManagerCertificate = list(
              CertificateAuthorityArn = "string",
              CreatedAt = "string",
              DomainName = "string",
              DomainValidationOptions = list(
                list(
                  DomainName = "string",
                  ResourceRecord = list(
                    Name = "string",
                    Type = "string",
                    Value = "string"
                  ),
                  ValidationDomain = "string",
                  ValidationEmails = list(
                    "string"
                  ),
                  ValidationMethod = "string",
                  ValidationStatus = "string"
                )
              ),
              ExtendedKeyUsages = list(
                list(
                  Name = "string",
                  OId = "string"
                )
              ),
              FailureReason = "string",
              ImportedAt = "string",
              InUseBy = list(
                "string"
              ),
              IssuedAt = "string",
              Issuer = "string",
              KeyAlgorithm = "string",
              KeyUsages = list(
                list(
                  Name = "string"
                )
              ),
              NotAfter = "string",
              NotBefore = "string",
              Options = list(
                CertificateTransparencyLoggingPreference = "string"
              ),
              RenewalEligibility = "string",
              RenewalSummary = list(
                DomainValidationOptions = list(
                  list(
                    DomainName = "string",
                    ResourceRecord = list(
                      Name = "string",
                      Type = "string",
                      Value = "string"
                    ),
                    ValidationDomain = "string",
                    ValidationEmails = list(
                      "string"
                    ),
                    ValidationMethod = "string",
                    ValidationStatus = "string"
                  )
                ),
                RenewalStatus = "string",
                RenewalStatusReason = "string",
                UpdatedAt = "string"
              ),
              Serial = "string",
              SignatureAlgorithm = "string",
              Status = "string",
              Subject = "string",
              SubjectAlternativeNames = list(
                "string"
              ),
              Type = "string"
            ),
            AwsRedshiftCluster = list(
              AllowVersionUpgrade = TRUE|FALSE,
              AutomatedSnapshotRetentionPeriod = 123,
              AvailabilityZone = "string",
              ClusterAvailabilityStatus = "string",
              ClusterCreateTime = "string",
              ClusterIdentifier = "string",
              ClusterNodes = list(
                list(
                  NodeRole = "string",
                  PrivateIpAddress = "string",
                  PublicIpAddress = "string"
                )
              ),
              ClusterParameterGroups = list(
                list(
                  ClusterParameterStatusList = list(
                    list(
                      ParameterName = "string",
                      ParameterApplyStatus = "string",
                      ParameterApplyErrorDescription = "string"
                    )
                  ),
                  ParameterApplyStatus = "string",
                  ParameterGroupName = "string"
                )
              ),
              ClusterPublicKey = "string",
              ClusterRevisionNumber = "string",
              ClusterSecurityGroups = list(
                list(
                  ClusterSecurityGroupName = "string",
                  Status = "string"
                )
              ),
              ClusterSnapshotCopyStatus = list(
                DestinationRegion = "string",
                ManualSnapshotRetentionPeriod = 123,
                RetentionPeriod = 123,
                SnapshotCopyGrantName = "string"
              ),
              ClusterStatus = "string",
              ClusterSubnetGroupName = "string",
              ClusterVersion = "string",
              DBName = "string",
              DeferredMaintenanceWindows = list(
                list(
                  DeferMaintenanceEndTime = "string",
                  DeferMaintenanceIdentifier = "string",
                  DeferMaintenanceStartTime = "string"
                )
              ),
              ElasticIpStatus = list(
                ElasticIp = "string",
                Status = "string"
              ),
              ElasticResizeNumberOfNodeOptions = "string",
              Encrypted = TRUE|FALSE,
              Endpoint = list(
                Address = "string",
                Port = 123
              ),
              EnhancedVpcRouting = TRUE|FALSE,
              ExpectedNextSnapshotScheduleTime = "string",
              ExpectedNextSnapshotScheduleTimeStatus = "string",
              HsmStatus = list(
                HsmClientCertificateIdentifier = "string",
                HsmConfigurationIdentifier = "string",
                Status = "string"
              ),
              IamRoles = list(
                list(
                  ApplyStatus = "string",
                  IamRoleArn = "string"
                )
              ),
              KmsKeyId = "string",
              MaintenanceTrackName = "string",
              ManualSnapshotRetentionPeriod = 123,
              MasterUsername = "string",
              NextMaintenanceWindowStartTime = "string",
              NodeType = "string",
              NumberOfNodes = 123,
              PendingActions = list(
                "string"
              ),
              PendingModifiedValues = list(
                AutomatedSnapshotRetentionPeriod = 123,
                ClusterIdentifier = "string",
                ClusterType = "string",
                ClusterVersion = "string",
                EncryptionType = "string",
                EnhancedVpcRouting = TRUE|FALSE,
                MaintenanceTrackName = "string",
                MasterUserPassword = "string",
                NodeType = "string",
                NumberOfNodes = 123,
                PubliclyAccessible = TRUE|FALSE
              ),
              PreferredMaintenanceWindow = "string",
              PubliclyAccessible = TRUE|FALSE,
              ResizeInfo = list(
                AllowCancelResize = TRUE|FALSE,
                ResizeType = "string"
              ),
              RestoreStatus = list(
                CurrentRestoreRateInMegaBytesPerSecond = 123.0,
                ElapsedTimeInSeconds = 123,
                EstimatedTimeToCompletionInSeconds = 123,
                ProgressInMegaBytes = 123,
                SnapshotSizeInMegaBytes = 123,
                Status = "string"
              ),
              SnapshotScheduleIdentifier = "string",
              SnapshotScheduleState = "string",
              VpcId = "string",
              VpcSecurityGroups = list(
                list(
                  Status = "string",
                  VpcSecurityGroupId = "string"
                )
              )
            ),
            AwsElbLoadBalancer = list(
              AvailabilityZones = list(
                "string"
              ),
              BackendServerDescriptions = list(
                list(
                  InstancePort = 123,
                  PolicyNames = list(
                    "string"
                  )
                )
              ),
              CanonicalHostedZoneName = "string",
              CanonicalHostedZoneNameID = "string",
              CreatedTime = "string",
              DnsName = "string",
              HealthCheck = list(
                HealthyThreshold = 123,
                Interval = 123,
                Target = "string",
                Timeout = 123,
                UnhealthyThreshold = 123
              ),
              Instances = list(
                list(
                  InstanceId = "string"
                )
              ),
              ListenerDescriptions = list(
                list(
                  Listener = list(
                    InstancePort = 123,
                    InstanceProtocol = "string",
                    LoadBalancerPort = 123,
                    Protocol = "string",
                    SslCertificateId = "string"
                  ),
                  PolicyNames = list(
                    "string"
                  )
                )
              ),
              LoadBalancerAttributes = list(
                AccessLog = list(
                  EmitInterval = 123,
                  Enabled = TRUE|FALSE,
                  S3BucketName = "string",
                  S3BucketPrefix = "string"
                ),
                ConnectionDraining = list(
                  Enabled = TRUE|FALSE,
                  Timeout = 123
                ),
                ConnectionSettings = list(
                  IdleTimeout = 123
                ),
                CrossZoneLoadBalancing = list(
                  Enabled = TRUE|FALSE
                )
              ),
              LoadBalancerName = "string",
              Policies = list(
                AppCookieStickinessPolicies = list(
                  list(
                    CookieName = "string",
                    PolicyName = "string"
                  )
                ),
                LbCookieStickinessPolicies = list(
                  list(
                    CookieExpirationPeriod = 123,
                    PolicyName = "string"
                  )
                ),
                OtherPolicies = list(
                  "string"
                )
              ),
              Scheme = "string",
              SecurityGroups = list(
                "string"
              ),
              SourceSecurityGroup = list(
                GroupName = "string",
                OwnerAlias = "string"
              ),
              Subnets = list(
                "string"
              ),
              VpcId = "string"
            ),
            AwsIamGroup = list(
              AttachedManagedPolicies = list(
                list(
                  PolicyName = "string",
                  PolicyArn = "string"
                )
              ),
              CreateDate = "string",
              GroupId = "string",
              GroupName = "string",
              GroupPolicyList = list(
                list(
                  PolicyName = "string"
                )
              ),
              Path = "string"
            ),
            AwsIamRole = list(
              AssumeRolePolicyDocument = "string",
              AttachedManagedPolicies = list(
                list(
                  PolicyName = "string",
                  PolicyArn = "string"
                )
              ),
              CreateDate = "string",
              InstanceProfileList = list(
                list(
                  Arn = "string",
                  CreateDate = "string",
                  InstanceProfileId = "string",
                  InstanceProfileName = "string",
                  Path = "string",
                  Roles = list(
                    list(
                      Arn = "string",
                      AssumeRolePolicyDocument = "string",
                      CreateDate = "string",
                      Path = "string",
                      RoleId = "string",
                      RoleName = "string"
                    )
                  )
                )
              ),
              PermissionsBoundary = list(
                PermissionsBoundaryArn = "string",
                PermissionsBoundaryType = "string"
              ),
              RoleId = "string",
              RoleName = "string",
              RolePolicyList = list(
                list(
                  PolicyName = "string"
                )
              ),
              MaxSessionDuration = 123,
              Path = "string"
            ),
            AwsKmsKey = list(
              AWSAccountId = "string",
              CreationDate = 123.0,
              KeyId = "string",
              KeyManager = "string",
              KeyState = "string",
              Origin = "string",
              Description = "string"
            ),
            AwsLambdaFunction = list(
              Code = list(
                S3Bucket = "string",
                S3Key = "string",
                S3ObjectVersion = "string",
                ZipFile = "string"
              ),
              CodeSha256 = "string",
              DeadLetterConfig = list(
                TargetArn = "string"
              ),
              Environment = list(
                Variables = list(
                  "string"
                ),
                Error = list(
                  ErrorCode = "string",
                  Message = "string"
                )
              ),
              FunctionName = "string",
              Handler = "string",
              KmsKeyArn = "string",
              LastModified = "string",
              Layers = list(
                list(
                  Arn = "string",
                  CodeSize = 123
                )
              ),
              MasterArn = "string",
              MemorySize = 123,
              RevisionId = "string",
              Role = "string",
              Runtime = "string",
              Timeout = 123,
              TracingConfig = list(
                Mode = "string"
              ),
              VpcConfig = list(
                SecurityGroupIds = list(
                  "string"
                ),
                SubnetIds = list(
                  "string"
                ),
                VpcId = "string"
              ),
              Version = "string"
            ),
            AwsLambdaLayerVersion = list(
              Version = 123,
              CompatibleRuntimes = list(
                "string"
              ),
              CreatedDate = "string"
            ),
            AwsRdsDbInstance = list(
              AssociatedRoles = list(
                list(
                  RoleArn = "string",
                  FeatureName = "string",
                  Status = "string"
                )
              ),
              CACertificateIdentifier = "string",
              DBClusterIdentifier = "string",
              DBInstanceIdentifier = "string",
              DBInstanceClass = "string",
              DbInstancePort = 123,
              DbiResourceId = "string",
              DBName = "string",
              DeletionProtection = TRUE|FALSE,
              Endpoint = list(
                Address = "string",
                Port = 123,
                HostedZoneId = "string"
              ),
              Engine = "string",
              EngineVersion = "string",
              IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
              InstanceCreateTime = "string",
              KmsKeyId = "string",
              PubliclyAccessible = TRUE|FALSE,
              StorageEncrypted = TRUE|FALSE,
              TdeCredentialArn = "string",
              VpcSecurityGroups = list(
                list(
                  VpcSecurityGroupId = "string",
                  Status = "string"
                )
              ),
              MultiAz = TRUE|FALSE,
              EnhancedMonitoringResourceArn = "string",
              DbInstanceStatus = "string",
              MasterUsername = "string",
              AllocatedStorage = 123,
              PreferredBackupWindow = "string",
              BackupRetentionPeriod = 123,
              DbSecurityGroups = list(
                "string"
              ),
              DbParameterGroups = list(
                list(
                  DbParameterGroupName = "string",
                  ParameterApplyStatus = "string"
                )
              ),
              AvailabilityZone = "string",
              DbSubnetGroup = list(
                DbSubnetGroupName = "string",
                DbSubnetGroupDescription = "string",
                VpcId = "string",
                SubnetGroupStatus = "string",
                Subnets = list(
                  list(
                    SubnetIdentifier = "string",
                    SubnetAvailabilityZone = list(
                      Name = "string"
                    ),
                    SubnetStatus = "string"
                  )
                ),
                DbSubnetGroupArn = "string"
              ),
              PreferredMaintenanceWindow = "string",
              PendingModifiedValues = list(
                DbInstanceClass = "string",
                AllocatedStorage = 123,
                MasterUserPassword = "string",
                Port = 123,
                BackupRetentionPeriod = 123,
                MultiAZ = TRUE|FALSE,
                EngineVersion = "string",
                LicenseModel = "string",
                Iops = 123,
                DbInstanceIdentifier = "string",
                StorageType = "string",
                CaCertificateIdentifier = "string",
                DbSubnetGroupName = "string",
                PendingCloudWatchLogsExports = list(
                  LogTypesToEnable = list(
                    "string"
                  ),
                  LogTypesToDisable = list(
                    "string"
                  )
                ),
                ProcessorFeatures = list(
                  list(
                    Name = "string",
                    Value = "string"
                  )
                )
              ),
              LatestRestorableTime = "string",
              AutoMinorVersionUpgrade = TRUE|FALSE,
              ReadReplicaSourceDBInstanceIdentifier = "string",
              ReadReplicaDBInstanceIdentifiers = list(
                "string"
              ),
              ReadReplicaDBClusterIdentifiers = list(
                "string"
              ),
              LicenseModel = "string",
              Iops = 123,
              OptionGroupMemberships = list(
                list(
                  OptionGroupName = "string",
                  Status = "string"
                )
              ),
              CharacterSetName = "string",
              SecondaryAvailabilityZone = "string",
              StatusInfos = list(
                list(
                  StatusType = "string",
                  Normal = TRUE|FALSE,
                  Status = "string",
                  Message = "string"
                )
              ),
              StorageType = "string",
              DomainMemberships = list(
                list(
                  Domain = "string",
                  Status = "string",
                  Fqdn = "string",
                  IamRoleName = "string"
                )
              ),
              CopyTagsToSnapshot = TRUE|FALSE,
              MonitoringInterval = 123,
              MonitoringRoleArn = "string",
              PromotionTier = 123,
              Timezone = "string",
              PerformanceInsightsEnabled = TRUE|FALSE,
              PerformanceInsightsKmsKeyId = "string",
              PerformanceInsightsRetentionPeriod = 123,
              EnabledCloudWatchLogsExports = list(
                "string"
              ),
              ProcessorFeatures = list(
                list(
                  Name = "string",
                  Value = "string"
                )
              ),
              ListenerEndpoint = list(
                Address = "string",
                Port = 123,
                HostedZoneId = "string"
              ),
              MaxAllocatedStorage = 123
            ),
            AwsSnsTopic = list(
              KmsMasterKeyId = "string",
              Subscription = list(
                list(
                  Endpoint = "string",
                  Protocol = "string"
                )
              ),
              TopicName = "string",
              Owner = "string"
            ),
            AwsSqsQueue = list(
              KmsDataKeyReusePeriodSeconds = 123,
              KmsMasterKeyId = "string",
              QueueName = "string",
              DeadLetterTargetArn = "string"
            ),
            AwsWafWebAcl = list(
              Name = "string",
              DefaultAction = "string",
              Rules = list(
                list(
                  Action = list(
                    Type = "string"
                  ),
                  ExcludedRules = list(
                    list(
                      RuleId = "string"
                    )
                  ),
                  OverrideAction = list(
                    Type = "string"
                  ),
                  Priority = 123,
                  RuleId = "string",
                  Type = "string"
                )
              ),
              WebAclId = "string"
            ),
            AwsRdsDbSnapshot = list(
              DbSnapshotIdentifier = "string",
              DbInstanceIdentifier = "string",
              SnapshotCreateTime = "string",
              Engine = "string",
              AllocatedStorage = 123,
              Status = "string",
              Port = 123,
              AvailabilityZone = "string",
              VpcId = "string",
              InstanceCreateTime = "string",
              MasterUsername = "string",
              EngineVersion = "string",
              LicenseModel = "string",
              SnapshotType = "string",
              Iops = 123,
              OptionGroupName = "string",
              PercentProgress = 123,
              SourceRegion = "string",
              SourceDbSnapshotIdentifier = "string",
              StorageType = "string",
              TdeCredentialArn = "string",
              Encrypted = TRUE|FALSE,
              KmsKeyId = "string",
              Timezone = "string",
              IamDatabaseAuthenticationEnabled = TRUE|FALSE,
              ProcessorFeatures = list(
                list(
                  Name = "string",
                  Value = "string"
                )
              ),
              DbiResourceId = "string"
            ),
            AwsRdsDbClusterSnapshot = list(
              AvailabilityZones = list(
                "string"
              ),
              SnapshotCreateTime = "string",
              Engine = "string",
              AllocatedStorage = 123,
              Status = "string",
              Port = 123,
              VpcId = "string",
              ClusterCreateTime = "string",
              MasterUsername = "string",
              EngineVersion = "string",
              LicenseModel = "string",
              SnapshotType = "string",
              PercentProgress = 123,
              StorageEncrypted = TRUE|FALSE,
              KmsKeyId = "string",
              DbClusterIdentifier = "string",
              DbClusterSnapshotIdentifier = "string",
              IamDatabaseAuthenticationEnabled = TRUE|FALSE
            ),
            AwsRdsDbCluster = list(
              AllocatedStorage = 123,
              AvailabilityZones = list(
                "string"
              ),
              BackupRetentionPeriod = 123,
              DatabaseName = "string",
              Status = "string",
              Endpoint = "string",
              ReaderEndpoint = "string",
              CustomEndpoints = list(
                "string"
              ),
              MultiAz = TRUE|FALSE,
              Engine = "string",
              EngineVersion = "string",
              Port = 123,
              MasterUsername = "string",
              PreferredBackupWindow = "string",
              PreferredMaintenanceWindow = "string",
              ReadReplicaIdentifiers = list(
                "string"
              ),
              VpcSecurityGroups = list(
                list(
                  VpcSecurityGroupId = "string",
                  Status = "string"
                )
              ),
              HostedZoneId = "string",
              StorageEncrypted = TRUE|FALSE,
              KmsKeyId = "string",
              DbClusterResourceId = "string",
              AssociatedRoles = list(
                list(
                  RoleArn = "string",
                  Status = "string"
                )
              ),
              ClusterCreateTime = "string",
              EnabledCloudWatchLogsExports = list(
                "string"
              ),
              EngineMode = "string",
              DeletionProtection = TRUE|FALSE,
              HttpEndpointEnabled = TRUE|FALSE,
              ActivityStreamStatus = "string",
              CopyTagsToSnapshot = TRUE|FALSE,
              CrossAccountClone = TRUE|FALSE,
              DomainMemberships = list(
                list(
                  Domain = "string",
                  Status = "string",
                  Fqdn = "string",
                  IamRoleName = "string"
                )
              ),
              DbClusterParameterGroup = "string",
              DbSubnetGroup = "string",
              DbClusterOptionGroupMemberships = list(
                list(
                  DbClusterOptionGroupName = "string",
                  Status = "string"
                )
              ),
              DbClusterIdentifier = "string",
              DbClusterMembers = list(
                list(
                  IsClusterWriter = TRUE|FALSE,
                  PromotionTier = 123,
                  DbInstanceIdentifier = "string",
                  DbClusterParameterGroupStatus = "string"
                )
              ),
              IamDatabaseAuthenticationEnabled = TRUE|FALSE
            ),
            Container = list(
              Name = "string",
              ImageId = "string",
              ImageName = "string",
              LaunchedAt = "string"
            ),
            Other = list(
              "string"
            )
          )
        )
      ),
      Compliance = list(
        Status = "PASSED"|"WARNING"|"FAILED"|"NOT_AVAILABLE",
        RelatedRequirements = list(
          "string"
        ),
        StatusReasons = list(
          list(
            ReasonCode = "string",
            Description = "string"
          )
        )
      ),
      VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
      WorkflowState = "NEW"|"ASSIGNED"|"IN_PROGRESS"|"DEFERRED"|"RESOLVED",
      Workflow = list(
        Status = "NEW"|"NOTIFIED"|"RESOLVED"|"SUPPRESSED"
      ),
      RecordState = "ACTIVE"|"ARCHIVED",
      RelatedFindings = list(
        list(
          ProductArn = "string",
          Id = "string"
        )
      ),
      Note = list(
        Text = "string",
        UpdatedBy = "string",
        UpdatedAt = "string"
      ),
      Vulnerabilities = list(
        list(
          Id = "string",
          VulnerablePackages = list(
            list(
              Name = "string",
              Version = "string",
              Epoch = "string",
              Release = "string",
              Architecture = "string"
            )
          ),
          Cvss = list(
            list(
              Version = "string",
              BaseScore = 123.0,
              BaseVector = "string"
            )
          ),
          RelatedVulnerabilities = list(
            "string"
          ),
          Vendor = list(
            Name = "string",
            Url = "string",
            VendorSeverity = "string",
            VendorCreatedAt = "string",
            VendorUpdatedAt = "string"
          ),
          ReferenceUrls = list(
            "string"
          )
        )
      ),
      PatchSummary = list(
        Id = "string",
        InstalledCount = 123,
        MissingCount = 123,
        FailedCount = 123,
        InstalledOtherCount = 123,
        InstalledRejectedCount = 123,
        InstalledPendingReboot = 123,
        OperationStartTime = "string",
        OperationEndTime = "string",
        RebootOption = "string",
        Operation = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of findings that match the specified criteria.
}
\section{Request syntax}{
\preformatted{svc$get_findings(
  Filters = list(
    ProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    AwsAccountId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Id = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    GeneratorId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Type = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    FirstObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    LastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    CreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    UpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    SeverityProduct = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityNormalized = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityLabel = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Confidence = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Criticality = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Title = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Description = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RecommendationText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    SourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProductFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ProductName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    CompanyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    UserDefinedFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    MalwareName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwareType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwarePath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    MalwareState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkDirection = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkProtocol = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkSourceIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourceIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourcePort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkSourceDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkSourceMac = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NetworkDestinationIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationPort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkDestinationDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessPath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ProcessPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessParentPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ProcessTerminatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorValue = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorCategory = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorLastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorSource = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ThreatIntelIndicatorSourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourcePartition = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceRegion = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceTags = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceIpV4Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceIpV6Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceKeyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceIamInstanceProfileArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceVpcId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceSubnetId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsEc2InstanceLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceAwsS3BucketOwnerId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsS3BucketOwnerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyUserName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceAwsIamAccessKeyCreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceContainerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerImageName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    ResourceContainerLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceDetailsOther = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "EQUALS"|"NOT_EQUALS"
      )
    ),
    ComplianceStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    VerificationState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    WorkflowState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    WorkflowStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RecordState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RelatedFindingsProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    RelatedFindingsId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NoteText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    NoteUpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    NoteUpdatedBy = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"PREFIX"|"NOT_EQUALS"|"PREFIX_NOT_EQUALS"
      )
    ),
    Keyword = list(
      list(
        Value = "string"
      )
    )
  ),
  SortCriteria = list(
    list(
      Field = "string",
      SortOrder = "asc"|"desc"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
