% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_list_findings}
\alias{guardduty_list_findings}
\title{Lists Amazon GuardDuty findings for the specified detector ID}
\usage{
guardduty_list_findings(DetectorId, FindingCriteria, SortCriteria,
  MaxResults, NextToken)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector that specifies the GuardDuty service whose
findings you want to list.}

\item{FindingCriteria}{Represents the criteria used for querying findings.}

\item{SortCriteria}{Represents the criteria used for sorting findings.}

\item{MaxResults}{You can use this parameter to indicate the maximum number of items you
want in the response. The default value is 50. The maximum value is 50.}

\item{NextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the list action. For
subsequent calls to the action fill nextToken in the request with the
value of NextToken from the previous response to continue listing data.}
}
\description{
Lists Amazon GuardDuty findings for the specified detector ID.
}
\section{Request syntax}{
\preformatted{svc$list_findings(
  DetectorId = "string",
  FindingCriteria = list(
    Criterion = list(
      list(
        Eq = list(
          "string"
        ),
        Neq = list(
          "string"
        ),
        Gt = 123,
        Gte = 123,
        Lt = 123,
        Lte = 123,
        Equals = list(
          "string"
        ),
        NotEquals = list(
          "string"
        ),
        GreaterThan = 123,
        GreaterThanOrEqual = 123,
        LessThan = 123,
        LessThanOrEqual = 123
      )
    )
  ),
  SortCriteria = list(
    AttributeName = "string",
    OrderBy = "ASC"|"DESC"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
