% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_upload_signing_certificate}
\alias{iam_upload_signing_certificate}
\title{Uploads an X}
\usage{
iam_upload_signing_certificate(UserName, CertificateBody)
}
\arguments{
\item{UserName}{The name of the user the signing certificate is for.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{CertificateBody}{[required] The contents of the signing certificate.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} used to validate
this parameter is a string of characters consisting of the following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \code{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\code{U+000A}), and
carriage return (\code{U+000D})
}}
}
\description{
Uploads an X.509 signing certificate and associates it with the
specified IAM user. Some AWS services use X.509 signing certificates to
validate requests that are signed with a corresponding private key. When
you upload the certificate, its default status is \code{Active}.
}
\details{
If the \code{UserName} is not specified, the IAM user name is determined
implicitly based on the AWS access key ID used to sign the request. This
operation works for access keys under the AWS account. Consequently, you
can use this operation to manage AWS account root user credentials even
if the AWS account has no associated users.

Because the body of an X.509 certificate can be large, you should use
POST rather than GET when calling \code{UploadSigningCertificate}. For
information about setting up signatures and authorization through the
API, go to \href{https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html}{Signing AWS API Requests}
in the \emph{AWS General Reference}. For general information about using the
Query API with IAM, go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html}{Making Query Requests}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$upload_signing_certificate(
  UserName = "string",
  CertificateBody = "string"
)
}
}

\examples{
# The following command uploads a signing certificate for the IAM user
# named Bob.
\donttest{svc$upload_signing_certificate(
  CertificateBody = "-----BEGIN CERTIFICATE-----<certificate-body>-----END CERTIFICATE-----",
  UserName = "Bob"
)}

}
\keyword{internal}
