% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_describe_certificate_authority_audit_report}
\alias{acmpca_describe_certificate_authority_audit_report}
\title{Lists information about a specific audit report created by calling the
CreateCertificateAuthorityAuditReport action}
\usage{
acmpca_describe_certificate_authority_audit_report(
  CertificateAuthorityArn, AuditReportId)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the private CA. This must be of the
form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{AuditReportId}{[required] The report ID returned by calling the
CreateCertificateAuthorityAuditReport action.}
}
\description{
Lists information about a specific audit report created by calling the
CreateCertificateAuthorityAuditReport action. Audit information is
created every time the certificate authority (CA) private key is used.
The private key is used when you call the IssueCertificate action or the
RevokeCertificate action.
}
\section{Request syntax}{
\preformatted{svc$describe_certificate_authority_audit_report(
  CertificateAuthorityArn = "string",
  AuditReportId = "string"
)
}
}

\keyword{internal}
