% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_grants}
\alias{kms_list_grants}
\title{Gets a list of all grants for the specified customer master key (CMK)}
\usage{
kms_list_grants(Limit, Marker, KeyId)
}
\arguments{
\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, AWS KMS does not return more than the
specified number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
100, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}

\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
specify a CMK in a different AWS account, you must use the key ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}
}
\description{
Gets a list of all grants for the specified customer master key (CMK).
}
\details{
To perform this operation on a CMK in a different AWS account, specify
the key ARN in the value of the \code{KeyId} parameter.
}
\section{Request syntax}{
\preformatted{svc$list_grants(
  Limit = 123,
  Marker = "string",
  KeyId = "string"
)
}
}

\examples{
# The following example lists grants for the specified CMK.
\donttest{svc$list_grants(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
