% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_change_password}
\alias{iam_change_password}
\title{Changes the password of the IAM user who is calling this operation}
\usage{
iam_change_password(OldPassword, NewPassword)
}
\arguments{
\item{OldPassword}{[required] The IAM user\'s current password.}

\item{NewPassword}{[required] The new password. The new password must conform to the AWS account\'s
password policy, if one exists.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} that is used to
validate this parameter is a string of characters. That string can
include almost any printable ASCII character from the space (\code{U+0020})
through the end of the ASCII character range (\verb{U+00FF}). You can also
include the tab (\code{U+0009}), line feed (\verb{U+000A}), and carriage return
(\verb{U+000D}) characters. Any of these characters are valid in a password.
However, many tools, such as the AWS Management Console, might restrict
the ability to type certain characters because they have special meaning
within that tool.}
}
\description{
Changes the password of the IAM user who is calling this operation. The
AWS account root user password is not affected by this operation.
}
\details{
To change the password for a different user, see UpdateLoginProfile. For
more information about modifying passwords, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html}{Managing Passwords}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$change_password(
  OldPassword = "string",
  NewPassword = "string"
)
}
}

\examples{
# The following command changes the password for the current IAM user.
\dontrun{svc$change_password(
  NewPassword = "]35d/\{pB9Fo9wJ",
  OldPassword = "3s0K_;xh4~8XXI"
)}

}
\keyword{internal}
