% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_delete_resource_policy}
\alias{secretsmanager_delete_resource_policy}
\title{Deletes the resource-based permission policy that's attached to the
secret}
\usage{
secretsmanager_delete_resource_policy(SecretId)
}
\arguments{
\item{SecretId}{[required] Specifies the secret that you want to delete the attached resource-based
policy for. You can specify either the Amazon Resource Name (ARN) or the
friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}
}
\description{
Deletes the resource-based permission policy that\'s attached to the
secret.
}
\details{
\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:DeleteResourcePolicy
}

\strong{Related operations}
\itemize{
\item To attach a resource policy to a secret, use PutResourcePolicy.
\item To retrieve the current resource-based policy that\'s attached to a
secret, use GetResourcePolicy.
\item To list all of the currently available secrets, use ListSecrets.
}
}
\section{Request syntax}{
\preformatted{svc$delete_resource_policy(
  SecretId = "string"
)
}
}

\examples{
# The following example shows how to delete the resource-based policy that
# is attached to a secret.
\dontrun{svc$delete_resource_policy(
  SecretId = "MyTestDatabaseSecret"
)}

}
\keyword{internal}
