% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_update_secret_version_stage}
\alias{secretsmanager_update_secret_version_stage}
\title{Modifies the staging labels attached to a version of a secret}
\usage{
secretsmanager_update_secret_version_stage(SecretId, VersionStage,
  RemoveFromVersionId, MoveToVersionId)
}
\arguments{
\item{SecretId}{[required] Specifies the secret with the version whose list of staging labels you
want to modify. You can specify either the Amazon Resource Name (ARN) or
the friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}

\item{VersionStage}{[required] The staging label to add to this version.}

\item{RemoveFromVersionId}{Specifies the secret version ID of the version that the staging label is
to be removed from. If the staging label you are trying to attach to one
version is already attached to a different version, then you must
include this parameter and specify the version that the label is to be
removed from. If the label is attached and you either do not specify
this parameter, or the version ID does not match, then the operation
fails.}

\item{MoveToVersionId}{(Optional) The secret version ID that you want to add the staging label
to. If you want to remove a label from a version, then do not specify
this parameter.

If the staging label is already attached to a different version of the
secret, then you must also specify the \code{RemoveFromVersionId} parameter.}
}
\description{
Modifies the staging labels attached to a version of a secret. Staging
labels are used to track a version as it progresses through the secret
rotation process. You can attach a staging label to only one version of
a secret at a time. If a staging label to be added is already attached
to another version, then it is moved\\--removed from the other version
first and then attached to this one. For more information about staging
labels, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label}{Staging Labels}
in the \emph{AWS Secrets Manager User Guide}.
}
\details{
The staging labels that you specify in the \code{VersionStage} parameter are
added to the existing list of staging labels\\--they don\'t replace it.

You can move the \code{AWSCURRENT} staging label to this version by including
it in this call.

Whenever you move \code{AWSCURRENT}, Secrets Manager automatically moves the
label \code{AWSPREVIOUS} to the version that \code{AWSCURRENT} was removed from.

If this action results in the last label being removed from a version,
then the version is considered to be \'deprecated\' and can be deleted
by Secrets Manager.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:UpdateSecretVersionStage
}

\strong{Related operations}
\itemize{
\item To get the list of staging labels that are currently associated with
a version of a secret, use \verb{<a>DescribeSecret</a>} and examine the
\code{SecretVersionsToStages} response value.
}
}
\section{Request syntax}{
\preformatted{svc$update_secret_version_stage(
  SecretId = "string",
  VersionStage = "string",
  RemoveFromVersionId = "string",
  MoveToVersionId = "string"
)
}
}

\examples{
# The following example shows you how to add a staging label to a version
# of a secret. You can review the results by running the operation
# ListSecretVersionIds and viewing the VersionStages response field for
# the affected version.
\dontrun{svc$update_secret_version_stage(
  MoveToVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
  SecretId = "MyTestDatabaseSecret",
  VersionStage = "STAGINGLABEL1"
)}

# The following example shows you how to delete a staging label that is
# attached to a version of a secret. You can review the results by running
# the operation ListSecretVersionIds and viewing the VersionStages
# response field for the affected version.
\dontrun{svc$update_secret_version_stage(
  RemoveFromVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
  SecretId = "MyTestDatabaseSecret",
  VersionStage = "STAGINGLABEL1"
)}

# The following example shows you how to move a staging label that is
# attached to one version of a secret to a different version. You can
# review the results by running the operation ListSecretVersionIds and
# viewing the VersionStages response field for the affected version.
\dontrun{svc$update_secret_version_stage(
  MoveToVersionId = "EXAMPLE2-90ab-cdef-fedc-ba987SECRET2",
  RemoveFromVersionId = "EXAMPLE1-90ab-cdef-fedc-ba987SECRET1",
  SecretId = "MyTestDatabaseSecret",
  VersionStage = "AWSCURRENT"
)}

}
\keyword{internal}
