% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_list_ip_sets}
\alias{wafregional_list_ip_sets}
\title{Returns an array of IPSetSummary objects in the response}
\usage{
wafregional_list_ip_sets(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{AWS WAF returns a \code{NextMarker} value in the response that allows you to
list another group of \code{IPSets}. For the second and subsequent
\code{ListIPSets} requests, specify the value of \code{NextMarker} from the
previous response to get information about another batch of \code{IPSets}.}

\item{Limit}{Specifies the number of \code{IPSet} objects that you want AWS WAF to return
for this request. If you have more \code{IPSet} objects than the number you
specify for \code{Limit}, the response includes a \code{NextMarker} value that you
can use to get another batch of \code{IPSet} objects.}
}
\description{
Returns an array of IPSetSummary objects in the response.
}
\section{Request syntax}{
\preformatted{svc$list_ip_sets(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
# The following example returns an array of up to 100 IP match sets.
\dontrun{svc$list_ip_sets(
  Limit = 100L
)}

}
\keyword{internal}
