% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool_client}
\alias{cognitoidentityprovider_create_user_pool_client}
\title{Creates the user pool client}
\usage{
cognitoidentityprovider_create_user_pool_client(UserPoolId, ClientName,
  GenerateSecret, RefreshTokenValidity, ReadAttributes, WriteAttributes,
  ExplicitAuthFlows, SupportedIdentityProviders, CallbackURLs, LogoutURLs,
  DefaultRedirectURI, AllowedOAuthFlows, AllowedOAuthScopes,
  AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration,
  PreventUserExistenceErrors)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to create a user pool
client.}

\item{ClientName}{[required] The client name for the user pool client you would like to create.}

\item{GenerateSecret}{Boolean to specify whether you want to generate a secret for the user
pool client being created.}

\item{RefreshTokenValidity}{The time limit, in days, after which the refresh token is no longer
valid and cannot be used.}

\item{ReadAttributes}{The read attributes.}

\item{WriteAttributes}{The user pool attributes that the app client can write to.

If your app client allows users to sign in through an identity provider,
this array must include all attributes that are mapped to identity
provider attributes. Amazon Cognito updates mapped attributes when users
sign in to your application through an identity provider. If your app
client lacks write access to a mapped attribute, Amazon Cognito throws
an error when it attempts to update the attribute. For more information,
see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html}{Specifying Identity Provider Attribute Mappings for Your User Pool}.}

\item{ExplicitAuthFlows}{The authentication flows that are supported by the user pool clients.
Flow names without the \code{ALLOW_} prefix are deprecated in favor of new
names with the \code{ALLOW_} prefix. Note that values with \code{ALLOW_} prefix
cannot be used along with values without \code{ALLOW_} prefix.

Valid values include:
\itemize{
\item \code{ALLOW_ADMIN_USER_PASSWORD_AUTH}: Enable admin based user password
authentication flow \code{ADMIN_USER_PASSWORD_AUTH}. This setting
replaces the \code{ADMIN_NO_SRP_AUTH} setting. With this authentication
flow, Cognito receives the password in the request instead of using
the SRP (Secure Remote Password protocol) protocol to verify
passwords.
\item \code{ALLOW_CUSTOM_AUTH}: Enable Lambda trigger based authentication.
\item \code{ALLOW_USER_PASSWORD_AUTH}: Enable user password-based
authentication. In this flow, Cognito receives the password in the
request instead of using the SRP protocol to verify passwords.
\item \code{ALLOW_USER_SRP_AUTH}: Enable SRP based authentication.
\item \code{ALLOW_REFRESH_TOKEN_AUTH}: Enable authflow to refresh tokens.
}}

\item{SupportedIdentityProviders}{A list of provider names for the identity providers that are supported
on this client. The following are supported: \code{COGNITO}, \code{Facebook},
\code{Google} and \code{LoginWithAmazon}.}

\item{CallbackURLs}{A list of allowed redirect (callback) URLs for the identity providers.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{LogoutURLs}{A list of allowed logout URLs for the identity providers.}

\item{DefaultRedirectURI}{The default redirect URI. Must be in the \code{CallbackURLs} list.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{AllowedOAuthFlows}{Set to \code{code} to initiate a code grant flow, which provides an
authorization code as the response. This code can be exchanged for
access tokens with the token endpoint.

Set to \code{token} to specify that the client should get the access token
(and, optionally, ID token, based on scopes) directly.}

\item{AllowedOAuthScopes}{A list of allowed \code{OAuth} scopes. Currently supported values are
\code{"phone"}, \code{"email"}, \code{"openid"}, and \code{"Cognito"}. In addition to these
values, custom scopes created in Resource Servers are also supported.}

\item{AllowedOAuthFlowsUserPoolClient}{Set to \code{True} if the client is allowed to follow the OAuth protocol when
interacting with Cognito user pools.}

\item{AnalyticsConfiguration}{The Amazon Pinpoint analytics configuration for collecting metrics for
this user pool.}

\item{PreventUserExistenceErrors}{Use this setting to choose which errors and responses are returned by
Cognito APIs during authentication, account confirmation, and password
recovery when the user does not exist in the user pool. When set to
\code{ENABLED} and the user does not exist, authentication returns an error
indicating either the username or password was incorrect, and account
confirmation and password recovery return a response indicating a code
was sent to a simulated destination. When set to \code{LEGACY}, those APIs
will return a \code{UserNotFoundException} exception if the user does not
exist in the user pool.

Valid values include:
\itemize{
\item \code{ENABLED} - This prevents user existence-related errors.
\item \code{LEGACY} - This represents the old behavior of Cognito where user
existence related errors are not prevented.
}

This setting affects the behavior of following APIs:
\itemize{
\item AdminInitiateAuth
\item AdminRespondToAuthChallenge
\item InitiateAuth
\item RespondToAuthChallenge
\item ForgotPassword
\item ConfirmForgotPassword
\item ConfirmSignUp
\item ResendConfirmationCode
}

After January 1st 2020, the value of \code{PreventUserExistenceErrors} will
default to \code{ENABLED} for newly created user pool clients if no value is
provided.}
}
\description{
Creates the user pool client.
}
\section{Request syntax}{
\preformatted{svc$create_user_pool_client(
  UserPoolId = "string",
  ClientName = "string",
  GenerateSecret = TRUE|FALSE,
  RefreshTokenValidity = 123,
  ReadAttributes = list(
    "string"
  ),
  WriteAttributes = list(
    "string"
  ),
  ExplicitAuthFlows = list(
    "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"|"ALLOW_ADMIN_USER_PASSWORD_AUTH"|"ALLOW_CUSTOM_AUTH"|"ALLOW_USER_PASSWORD_AUTH"|"ALLOW_USER_SRP_AUTH"|"ALLOW_REFRESH_TOKEN_AUTH"
  ),
  SupportedIdentityProviders = list(
    "string"
  ),
  CallbackURLs = list(
    "string"
  ),
  LogoutURLs = list(
    "string"
  ),
  DefaultRedirectURI = "string",
  AllowedOAuthFlows = list(
    "code"|"implicit"|"client_credentials"
  ),
  AllowedOAuthScopes = list(
    "string"
  ),
  AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
  AnalyticsConfiguration = list(
    ApplicationId = "string",
    RoleArn = "string",
    ExternalId = "string",
    UserDataShared = TRUE|FALSE
  ),
  PreventUserExistenceErrors = "LEGACY"|"ENABLED"
)
}
}

\keyword{internal}
