# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kms_service.R
NULL

#' Cancels the deletion of a customer master key (CMK)
#'
#' Cancels the deletion of a customer master key (CMK). When this operation
#' succeeds, the key state of the CMK is `Disabled`. To enable the CMK, use
#' EnableKey. You cannot perform this operation on a CMK in a different AWS
#' account.
#' 
#' For more information about scheduling and canceling deletion of a CMK,
#' see [Deleting Customer Master
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_cancel_key_deletion(KeyId)
#'
#' @param KeyId &#91;required&#93; The unique identifier for the customer master key (CMK) for which to
#' cancel deletion.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_key_deletion(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example cancels deletion of the specified CMK.
#' svc$cancel_key_deletion(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_cancel_key_deletion
kms_cancel_key_deletion <- function(KeyId) {
  op <- new_operation(
    name = "CancelKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$cancel_key_deletion_input(KeyId = KeyId)
  output <- .kms$cancel_key_deletion_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$cancel_key_deletion <- kms_cancel_key_deletion

#' Connects or reconnects a custom key store to its associated AWS CloudHSM
#' cluster
#'
#' Connects or reconnects a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' to its associated AWS CloudHSM cluster.
#' 
#' The custom key store must be connected before you can create customer
#' master keys (CMKs) in the key store or use the CMKs it contains. You can
#' disconnect and reconnect a custom key store at any time.
#' 
#' To connect a custom key store, its associated AWS CloudHSM cluster must
#' have at least one active HSM. To get the number of active HSMs in a
#' cluster, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation. To add HSMs to the cluster, use the
#' [CreateHsm](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
#' operation. Also, the [`kmsuser` crypto
#' user](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#' (CU) must not be logged into the cluster. This prevents AWS KMS from
#' using this account to log in.
#' 
#' The connection process can take an extended amount of time to complete;
#' up to 20 minutes. This operation starts the connection process, but it
#' does not wait for it to complete. When it succeeds, this operation
#' quickly returns an HTTP 200 response and a JSON object with no
#' properties. However, this response does not indicate that the custom key
#' store is connected. To get the connection state of the custom key store,
#' use the DescribeCustomKeyStores operation.
#' 
#' During the connection process, AWS KMS finds the AWS CloudHSM cluster
#' that is associated with the custom key store, creates the connection
#' infrastructure, connects to the cluster, logs into the AWS CloudHSM
#' client as the `kmsuser` CU, and rotates its password.
#' 
#' The `ConnectCustomKeyStore` operation might fail for various reasons. To
#' find the reason, use the DescribeCustomKeyStores operation and see the
#' `ConnectionErrorCode` in the response. For help interpreting the
#' `ConnectionErrorCode`, see CustomKeyStoresListEntry.
#' 
#' To fix the failure, use the DisconnectCustomKeyStore operation to
#' disconnect the custom key store, correct the error, use the
#' UpdateCustomKeyStore operation if necessary, and then use
#' `ConnectCustomKeyStore` again.
#' 
#' If you are having trouble connecting or disconnecting a custom key
#' store, see [Troubleshooting a Custom Key
#' Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_connect_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the key store ID of the custom key store that you want to connect.
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$connect_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_connect_custom_key_store
kms_connect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "ConnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$connect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$connect_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$connect_custom_key_store <- kms_connect_custom_key_store

#' Creates a display name for a customer managed customer master key (CMK)
#'
#' Creates a display name for a customer managed customer master key (CMK).
#' You can use an alias to identify a CMK in [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations),
#' such as Encrypt and GenerateDataKey. You can change the CMK associated
#' with the alias at any time.
#' 
#' Aliases are easier to remember than key IDs. They can also help to
#' simplify your applications. For example, if you use an alias in your
#' code, you can change the CMK your code uses by associating a given alias
#' with a different CMK.
#' 
#' To run the same code in multiple AWS regions, use an alias in your code,
#' such as `alias/ApplicationKey`. Then, in each AWS Region, create an
#' `alias/ApplicationKey` alias that is associated with a CMK in that
#' Region. When you run your code, it uses the `alias/ApplicationKey` CMK
#' for that AWS Region without any Region-specific code.
#' 
#' This operation does not return a response. To get the alias that you
#' created, use the ListAliases operation.
#' 
#' To use aliases successfully, be aware of the following information.
#' 
#' -   Each alias points to only one CMK at a time, although a single CMK
#'     can have multiple aliases. The alias and its associated CMK must be
#'     in the same AWS account and Region.
#' 
#' -   You can associate an alias with any customer managed CMK in the same
#'     AWS account and Region. However, you do not have permission to
#'     associate an alias with an [AWS managed
#'     CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
#'     or an [AWS owned
#'     CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk).
#' 
#' -   To change the CMK associated with an alias, use the UpdateAlias
#'     operation. The current CMK and the new CMK must be the same type
#'     (both symmetric or both asymmetric) and they must have the same key
#'     usage (`ENCRYPT_DECRYPT` or `SIGN_VERIFY`). This restriction
#'     prevents cryptographic errors in code that uses aliases.
#' 
#' -   The alias name must begin with `alias/` followed by a name, such as
#'     `alias/ExampleAlias`. It can contain only alphanumeric characters,
#'     forward slashes (/), underscores (\\_), and dashes (-). The alias
#'     name cannot begin with `alias/aws/`. The `alias/aws/` prefix is
#'     reserved for [AWS managed
#'     CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' 
#' -   The alias name must be unique within an AWS Region. However, you can
#'     use the same alias name in multiple Regions of the same AWS account.
#'     Each instance of the alias is associated with a CMK in its Region.
#' 
#' -   After you create an alias, you cannot change its alias name.
#'     However, you can use the DeleteAlias operation to delete the alias
#'     and then create a new alias with the desired name.
#' 
#' -   You can use an alias name or alias ARN to identify a CMK in AWS KMS
#'     [cryptographic
#'     operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#'     and in the DescribeKey operation. However, you cannot use alias
#'     names or alias ARNs in API operations that manage CMKs, such as
#'     DisableKey or GetKeyPolicy. For information about the valid CMK
#'     identifiers for each AWS KMS API operation, see the descriptions of
#'     the `KeyId` parameter in the API operation documentation.
#' 
#' Because an alias is not a property of a CMK, you can delete and change
#' the aliases of a CMK without affecting the CMK. Also, aliases do not
#' appear in the response from the DescribeKey operation. To get the
#' aliases and alias ARNs of CMKs in each AWS account and Region, use the
#' ListAliases operation.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_alias(AliasName, TargetKeyId)
#'
#' @param AliasName &#91;required&#93; Specifies the alias name. This value must begin with `alias/` followed
#' by a name, such as `alias/ExampleAlias`. The alias name cannot begin
#' with `alias/aws/`. The `alias/aws/` prefix is reserved for AWS managed
#' CMKs.
#' @param TargetKeyId &#91;required&#93; Identifies the CMK to which the alias refers. Specify the key ID or the
#' Amazon Resource Name (ARN) of the CMK. You cannot specify another alias.
#' For help finding the key ID and ARN, see [Finding the Key ID and
#' ARN](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_alias(
#'   AliasName = "string",
#'   TargetKeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates an alias for the specified customer master
#' # key (CMK).
#' svc$create_alias(
#'   AliasName = "alias/ExampleAlias",
#'   TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_create_alias
kms_create_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$create_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_alias <- kms_create_alias

#' Creates a custom key store that is associated with an AWS CloudHSM
#' cluster that you own and manage
#'
#' Creates a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' that is associated with an [AWS CloudHSM
#' cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html)
#' that you own and manage.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' 
#' Before you create the custom key store, you must assemble the required
#' elements, including an AWS CloudHSM cluster that fulfills the
#' requirements for a custom key store. For details about the required
#' elements, see [Assemble the
#' Prerequisites](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' When the operation completes successfully, it returns the ID of the new
#' custom key store. Before you can use your new custom key store, you need
#' to use the ConnectCustomKeyStore operation to connect the new key store
#' to its AWS CloudHSM cluster. Even if you are not going to use your
#' custom key store immediately, you might want to connect it to verify
#' that all settings are correct and then disconnect it until you are ready
#' to use it.
#' 
#' For help with failures, see [Troubleshooting a Custom Key
#' Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_custom_key_store(CustomKeyStoreName, CloudHsmClusterId,
#'   TrustAnchorCertificate, KeyStorePassword)
#'
#' @param CustomKeyStoreName &#91;required&#93; Specifies a friendly name for the custom key store. The name must be
#' unique in your AWS account.
#' @param CloudHsmClusterId &#91;required&#93; Identifies the AWS CloudHSM cluster for the custom key store. Enter the
#' cluster ID of any active AWS CloudHSM cluster that is not already
#' associated with a custom key store. To find the cluster ID, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#' @param TrustAnchorCertificate &#91;required&#93; Enter the content of the trust anchor certificate for the cluster. This
#' is the content of the `customerCA.crt` file that you created when you
#' [initialized the
#' cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
#' @param KeyStorePassword &#91;required&#93; Enter the password of the [`kmsuser` crypto user (CU)
#' account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#' in the specified AWS CloudHSM cluster. AWS KMS logs into the cluster as
#' this user to manage key material on your behalf.
#' 
#' The password must be a string of 7 to 32 characters. Its value is case
#' sensitive.
#' 
#' This parameter tells AWS KMS the `kmsuser` account password; it does not
#' change the password in the AWS CloudHSM cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_custom_key_store(
#'   CustomKeyStoreName = "string",
#'   CloudHsmClusterId = "string",
#'   TrustAnchorCertificate = "string",
#'   KeyStorePassword = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_create_custom_key_store
kms_create_custom_key_store <- function(CustomKeyStoreName, CloudHsmClusterId, TrustAnchorCertificate, KeyStorePassword) {
  op <- new_operation(
    name = "CreateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_custom_key_store_input(CustomKeyStoreName = CustomKeyStoreName, CloudHsmClusterId = CloudHsmClusterId, TrustAnchorCertificate = TrustAnchorCertificate, KeyStorePassword = KeyStorePassword)
  output <- .kms$create_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_custom_key_store <- kms_create_custom_key_store

#' Adds a grant to a customer master key (CMK)
#'
#' Adds a grant to a customer master key (CMK). The grant allows the
#' grantee principal to use the CMK when the conditions specified in the
#' grant are met. When setting permissions, grants are an alternative to
#' key policies.
#' 
#' To create a grant that allows a [cryptographic
#' operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' only when the request includes a particular [encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context),
#' use the `Constraints` parameter. For details, see GrantConstraints.
#' 
#' You can create grants on symmetric and asymmetric CMKs. However, if the
#' grant allows an operation that the CMK does not support, `CreateGrant`
#' fails with a `ValidationException`.
#' 
#' -   Grants for symmetric CMKs cannot allow operations that are not
#'     supported for symmetric CMKs, including Sign, Verify, and
#'     GetPublicKey. (There are limited exceptions to this rule for legacy
#'     operations, but you should not create a grant for an operation that
#'     AWS KMS does not support.)
#' 
#' -   Grants for asymmetric CMKs cannot allow operations that are not
#'     supported for asymmetric CMKs, including operations that [generate
#'     data
#'     keys](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey)
#'     or [data key
#'     pairs](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKeyPair),
#'     or operations related to [automatic key
#'     rotation](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html),
#'     [imported key
#'     material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
#'     or CMKs in [custom key
#'     stores](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' -   Grants for asymmetric CMKs with a `KeyUsage` of `ENCRYPT_DECRYPT`
#'     cannot allow the Sign or Verify operations. Grants for asymmetric
#'     CMKs with a `KeyUsage` of `SIGN_VERIFY` cannot allow the Encrypt or
#'     Decrypt operations.
#' 
#' -   Grants for asymmetric CMKs cannot include an encryption context
#'     grant constraint. An encryption context is not supported on
#'     asymmetric CMKs.
#' 
#' For information about symmetric and asymmetric CMKs, see [Using
#' Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter. For more information
#' about grants, see
#' [Grants](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
#' in the **AWS Key Management Service Developer Guide** .
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_grant(KeyId, GranteePrincipal, RetiringPrincipal, Operations,
#'   Constraints, GrantTokens, Name)
#'
#' @param KeyId &#91;required&#93; The unique identifier for the customer master key (CMK) that the grant
#' applies to.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param GranteePrincipal &#91;required&#93; The principal that is given permission to perform the operations that
#' the grant permits.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, IAM roles, federated users, and assumed role users. For
#' examples of the ARN syntax to use for specifying a principal, see [AWS
#' Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *AWS General Reference*.
#' @param RetiringPrincipal The principal that is given permission to retire the grant by using
#' RetireGrant operation.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, federated users, and assumed role users. For examples of the
#' ARN syntax to use for specifying a principal, see [AWS Identity and
#' Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *AWS General Reference*.
#' @param Operations &#91;required&#93; A list of operations that the grant permits.
#' @param Constraints Allows a [cryptographic
#' operation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' only when the encryption context matches or includes the encryption
#' context specified in this structure. For more information about
#' encryption context, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the **AWS Key Management Service Developer Guide** .
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#' @param Name A friendly name for identifying the grant. Use this value to prevent the
#' unintended creation of duplicate grants when retrying this request.
#' 
#' When this value is absent, all `CreateGrant` requests result in a new
#' grant with a unique `GrantId` even if all the supplied parameters are
#' identical. This can result in unintended duplicates when you retry the
#' `CreateGrant` request.
#' 
#' When this value is present, you can retry a `CreateGrant` request with
#' identical parameters; if the grant already exists, the original
#' `GrantId` is returned without creating a new grant. Note that the
#' returned grant token is unique with every `CreateGrant` request, even
#' when a duplicate `GrantId` is returned. All grant tokens obtained in
#' this way can be used interchangeably.
#'
#' @section Request syntax:
#' ```
#' svc$create_grant(
#'   KeyId = "string",
#'   GranteePrincipal = "string",
#'   RetiringPrincipal = "string",
#'   Operations = list(
#'     "Decrypt"|"Encrypt"|"GenerateDataKey"|"GenerateDataKeyWithoutPlaintext"|"ReEncryptFrom"|"ReEncryptTo"|"Sign"|"Verify"|"GetPublicKey"|"CreateGrant"|"RetireGrant"|"DescribeKey"|"GenerateDataKeyPair"|"GenerateDataKeyPairWithoutPlaintext"
#'   ),
#'   Constraints = list(
#'     EncryptionContextSubset = list(
#'       "string"
#'     ),
#'     EncryptionContextEquals = list(
#'       "string"
#'     )
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   ),
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a grant that allows the specified IAM role
#' # to encrypt data with the specified customer master key (CMK).
#' svc$create_grant(
#'   GranteePrincipal = "arn:aws:iam::111122223333:role/ExampleRole",
#'   KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Operations = list(
#'     "Encrypt",
#'     "Decrypt"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_create_grant
kms_create_grant <- function(KeyId, GranteePrincipal, RetiringPrincipal = NULL, Operations, Constraints = NULL, GrantTokens = NULL, Name = NULL) {
  op <- new_operation(
    name = "CreateGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_grant_input(KeyId = KeyId, GranteePrincipal = GranteePrincipal, RetiringPrincipal = RetiringPrincipal, Operations = Operations, Constraints = Constraints, GrantTokens = GrantTokens, Name = Name)
  output <- .kms$create_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_grant <- kms_create_grant

#' Creates a unique customer managed customer master key (CMK) in your AWS
#' account and Region
#'
#' Creates a unique customer managed [customer master
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master-keys)
#' (CMK) in your AWS account and Region. You cannot use this operation to
#' create a CMK in a different AWS account.
#' 
#' You can use the `CreateKey` operation to create symmetric or asymmetric
#' CMKs.
#' 
#' -   **Symmetric CMKs** contain a 256-bit symmetric key that never leaves
#'     AWS KMS unencrypted. To use the CMK, you must call AWS KMS. You can
#'     use a symmetric CMK to encrypt and decrypt small amounts of data,
#'     but they are typically used to generate [data
#'     keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys)
#'     and [data keys
#'     pairs](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-key-pairs).
#'     For details, see GenerateDataKey and GenerateDataKeyPair.
#' 
#' -   **Asymmetric CMKs** can contain an RSA key pair or an Elliptic Curve
#'     (ECC) key pair. The private key in an asymmetric CMK never leaves
#'     AWS KMS unencrypted. However, you can use the GetPublicKey operation
#'     to download the public key so it can be used outside of AWS KMS.
#'     CMKs with RSA key pairs can be used to encrypt or decrypt data or
#'     sign and verify messages (but not both). CMKs with ECC key pairs can
#'     be used only to sign and verify messages.
#' 
#' For information about symmetric and asymmetric CMKs, see [Using
#' Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' To create different types of CMKs, use the following guidance:
#' 
#' ### Asymmetric CMKs
#' 
#' To create an asymmetric CMK, use the `CustomerMasterKeySpec` parameter
#' to specify the type of key material in the CMK. Then, use the `KeyUsage`
#' parameter to determine whether the CMK will be used to encrypt and
#' decrypt or sign and verify. You can\'t change these properties after the
#' CMK is created.
#' 
#' ### Symmetric CMKs
#' 
#' When creating a symmetric CMK, you don\'t need to specify the
#' `CustomerMasterKeySpec` or `KeyUsage` parameters. The default value for
#' `CustomerMasterKeySpec`, `SYMMETRIC_DEFAULT`, and the default value for
#' `KeyUsage`, `ENCRYPT_DECRYPT`, are the only valid values for symmetric
#' CMKs.
#' 
#' ### Imported Key Material
#' 
#' To import your own key material, begin by creating a symmetric CMK with
#' no key material. To do this, use the `Origin` parameter of `CreateKey`
#' with a value of `EXTERNAL`. Next, use GetParametersForImport operation
#' to get a public key and import token, and use the public key to encrypt
#' your key material. Then, use ImportKeyMaterial with your import token to
#' import the key material. For step-by-step instructions, see [Importing
#' Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the **AWS Key Management Service Developer Guide** . You cannot
#' import the key material into an asymmetric CMK.
#' 
#' ### Custom Key Stores
#' 
#' To create a symmetric CMK in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' use the `CustomKeyStoreId` parameter to specify the custom key store.
#' You must also use the `Origin` parameter with a value of `AWS_CLOUDHSM`.
#' The AWS CloudHSM cluster that is associated with the custom key store
#' must have at least two active HSMs in different Availability Zones in
#' the AWS Region.
#' 
#' You cannot create an asymmetric CMK in a custom key store. For
#' information about custom key stores in AWS KMS see [Using Custom Key
#' Stores](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' in the **AWS Key Management Service Developer Guide** .
#'
#' @usage
#' kms_create_key(Policy, Description, KeyUsage, CustomerMasterKeySpec,
#'   Origin, CustomKeyStoreId, BypassPolicyLockoutSafetyCheck, Tags)
#'
#' @param Policy The key policy to attach to the CMK.
#' 
#' If you provide a key policy, it must meet the following criteria:
#' 
#' -   If you don\'t set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must allow the principal that is making the `CreateKey`
#'     request to make a subsequent PutKeyPolicy request on the CMK. This
#'     reduces the risk that the CMK becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the **AWS Key Management Service Developer Guide** .
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to AWS KMS. When you create a new AWS principal (for
#'     example, an IAM user or role), you might need to enforce a delay
#'     before including the new principal in a key policy because the new
#'     principal might not be immediately visible to AWS KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *AWS Identity and Access Management User Guide*.
#' 
#' If you do not provide a key policy, AWS KMS attaches a default key
#' policy to the CMK. For more information, see [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The key policy size quota is 32 kilobytes (32768 bytes).
#' @param Description A description of the CMK.
#' 
#' Use a description that helps you decide whether the CMK is appropriate
#' for a task.
#' @param KeyUsage Determines the [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' for which you can use the CMK. The default value is `ENCRYPT_DECRYPT`.
#' This parameter is required only for asymmetric CMKs. You can\'t change
#' the `KeyUsage` value after the CMK is created.
#' 
#' Select only one valid value.
#' 
#' -   For symmetric CMKs, omit the parameter or specify `ENCRYPT_DECRYPT`.
#' 
#' -   For asymmetric CMKs with RSA key material, specify `ENCRYPT_DECRYPT`
#'     or `SIGN_VERIFY`.
#' 
#' -   For asymmetric CMKs with ECC key material, specify `SIGN_VERIFY`.
#' @param CustomerMasterKeySpec Specifies the type of CMK to create. The default value,
#' `SYMMETRIC_DEFAULT`, creates a CMK with a 256-bit symmetric key for
#' encryption and decryption. For help choosing a key spec for your CMK,
#' see [How to Choose Your CMK
#' Configuration](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-choose.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The `CustomerMasterKeySpec` determines whether the CMK contains a
#' symmetric key or an asymmetric key pair. It also determines the
#' encryption algorithms or signing algorithms that the CMK supports. You
#' can\'t change the `CustomerMasterKeySpec` after the CMK is created. To
#' further restrict the algorithms that can be used with the CMK, use a
#' condition key in its key policy or IAM policy. For more information, see
#' [kms:EncryptionAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm)
#' or [kms:Signing
#' Algorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' [AWS services that are integrated with AWS
#' KMS](http://aws.amazon.com/kms/features/#AWS_Service_Integration) use
#' symmetric CMKs to protect your data. These services do not support
#' asymmetric CMKs. For help determining whether a CMK is symmetric or
#' asymmetric, see [Identifying Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/find-symm-asymm.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' AWS KMS supports the following key specs for CMKs:
#' 
#' -   Symmetric key (default)
#' 
#'     -   `SYMMETRIC_DEFAULT` (AES-256-GCM)
#' 
#' -   Asymmetric RSA key pairs
#' 
#'     -   `RSA_2048`
#' 
#'     -   `RSA_3072`
#' 
#'     -   `RSA_4096`
#' 
#' -   Asymmetric NIST-recommended elliptic curve key pairs
#' 
#'     -   `ECC_NIST_P256` (secp256r1)
#' 
#'     -   `ECC_NIST_P384` (secp384r1)
#' 
#'     -   `ECC_NIST_P521` (secp521r1)
#' 
#' -   Other asymmetric elliptic curve key pairs
#' 
#'     -   `ECC_SECG_P256K1` (secp256k1), commonly used for
#'         cryptocurrencies.
#' @param Origin The source of the key material for the CMK. You cannot change the origin
#' after you create the CMK. The default is `AWS_KMS`, which means AWS KMS
#' creates the key material.
#' 
#' When the parameter value is `EXTERNAL`, AWS KMS creates a CMK without
#' key material so that you can import key material from your existing key
#' management infrastructure. For more information about importing key
#' material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*. This value is valid
#' only for symmetric CMKs.
#' 
#' When the parameter value is `AWS_CLOUDHSM`, AWS KMS creates the CMK in
#' an AWS KMS [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and creates its key material in the associated AWS CloudHSM cluster. You
#' must also use the `CustomKeyStoreId` parameter to identify the custom
#' key store. This value is valid only for symmetric CMKs.
#' @param CustomKeyStoreId Creates the CMK in the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and the key material in its associated AWS CloudHSM cluster. To create a
#' CMK in a custom key store, you must also specify the `Origin` parameter
#' with a value of `AWS_CLOUDHSM`. The AWS CloudHSM cluster that is
#' associated with the custom key store must have at least two active HSMs,
#' each in a different Availability Zone in the Region.
#' 
#' This parameter is valid only for symmetric CMKs. You cannot create an
#' asymmetric CMK in a custom key store.
#' 
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#' 
#' The response includes the custom key store ID and the ID of the AWS
#' CloudHSM cluster.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the CMK becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the **AWS Key Management Service Developer Guide** .
#' 
#' Use this parameter only when you include a policy in the request and you
#' intend to prevent the principal that is making the request from making a
#' subsequent PutKeyPolicy request on the CMK.
#' 
#' The default value is false.
#' @param Tags One or more tags. Each tag consists of a tag key and a tag value. Both
#' the tag key and the tag value are required, but the tag value can be an
#' empty (null) string.
#' 
#' When you add tags to an AWS resource, AWS generates a cost allocation
#' report with usage and costs aggregated by tags. For information about
#' adding, changing, deleting and listing tags for CMKs, see [Tagging
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
#' 
#' Use this parameter to tag the CMK when it is created. To add tags to an
#' existing CMK, use the TagResource operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_key(
#'   Policy = "string",
#'   Description = "string",
#'   KeyUsage = "SIGN_VERIFY"|"ENCRYPT_DECRYPT",
#'   CustomerMasterKeySpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1"|"SYMMETRIC_DEFAULT",
#'   Origin = "AWS_KMS"|"EXTERNAL"|"AWS_CLOUDHSM",
#'   CustomKeyStoreId = "string",
#'   BypassPolicyLockoutSafetyCheck = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       TagKey = "string",
#'       TagValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a CMK.
#' svc$create_key(
#'   Tags = list(
#'     list(
#'       TagKey = "CreatedBy",
#'       TagValue = "ExampleUser"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_create_key
kms_create_key <- function(Policy = NULL, Description = NULL, KeyUsage = NULL, CustomerMasterKeySpec = NULL, Origin = NULL, CustomKeyStoreId = NULL, BypassPolicyLockoutSafetyCheck = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_key_input(Policy = Policy, Description = Description, KeyUsage = KeyUsage, CustomerMasterKeySpec = CustomerMasterKeySpec, Origin = Origin, CustomKeyStoreId = CustomKeyStoreId, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck, Tags = Tags)
  output <- .kms$create_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_key <- kms_create_key

#' Decrypts ciphertext that was encrypted by a AWS KMS customer master key
#' (CMK) using any of the following operations: - Encrypt - GenerateDataKey
#' - GenerateDataKeyPair - GenerateDataKeyWithoutPlaintext -
#' GenerateDataKeyPairWithoutPlaintext You can use this operation to
#' decrypt ciphertext that was encrypted under a symmetric or asymmetric
#' CMK
#'
#' Decrypts ciphertext that was encrypted by a AWS KMS customer master key
#' (CMK) using any of the following operations:
#' 
#' -   Encrypt
#' 
#' -   GenerateDataKey
#' 
#' -   GenerateDataKeyPair
#' 
#' -   GenerateDataKeyWithoutPlaintext
#' 
#' -   GenerateDataKeyPairWithoutPlaintext
#' 
#' You can use this operation to decrypt ciphertext that was encrypted
#' under a symmetric or asymmetric CMK. When the CMK is asymmetric, you
#' must specify the CMK and the encryption algorithm that was used to
#' encrypt the ciphertext. For information about symmetric and asymmetric
#' CMKs, see [Using Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The Decrypt operation also decrypts ciphertext that was encrypted
#' outside of AWS KMS by the public key in an AWS KMS asymmetric CMK.
#' However, it cannot decrypt ciphertext produced by other libraries, such
#' as the [AWS Encryption
#' SDK](https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/)
#' or [Amazon S3 client-side
#' encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
#' These libraries return a ciphertext format that is incompatible with AWS
#' KMS.
#' 
#' If the ciphertext was encrypted under a symmetric CMK, you do not need
#' to specify the CMK or the encryption algorithm. AWS KMS can get this
#' information from metadata that it adds to the symmetric ciphertext blob.
#' However, if you prefer, you can specify the `KeyId` to ensure that a
#' particular CMK is used to decrypt the ciphertext. If you specify a
#' different CMK than the one used to encrypt the ciphertext, the `Decrypt`
#' operation fails.
#' 
#' Whenever possible, use key policies to give users permission to call the
#' Decrypt operation on a particular CMK, instead of using IAM policies.
#' Otherwise, you might create an IAM user policy that gives the user
#' Decrypt permission on all CMKs. This user could decrypt ciphertext that
#' was encrypted by CMKs in other accounts if the key policy for the
#' cross-account CMK permits it. If you must use an IAM policy for
#' `Decrypt` permissions, limit the user to particular CMKs or particular
#' trusted accounts.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_decrypt(CiphertextBlob, EncryptionContext, GrantTokens, KeyId,
#'   EncryptionAlgorithm)
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext to be decrypted. The blob includes metadata.
#' @param EncryptionContext Specifies the encryption context to use when decrypting the data. An
#' encryption context is valid only for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' with a symmetric CMK. The standard asymmetric encryption algorithms that
#' AWS KMS uses do not support an encryption context.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#' @param KeyId Specifies the customer master key (CMK) that AWS KMS will use to decrypt
#' the ciphertext. Enter a key ID of the CMK that was used to encrypt the
#' ciphertext.
#' 
#' If you specify a `KeyId` value, the `Decrypt` operation succeeds only if
#' the specified CMK was used to encrypt the ciphertext.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric CMK. Otherwise, AWS KMS uses the metadata that it adds to
#' the ciphertext blob to determine which CMK was used to encrypt the
#' ciphertext. However, you can use this parameter to ensure that a
#' particular CMK (of any kind) is used to decrypt the ciphertext.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param EncryptionAlgorithm Specifies the encryption algorithm that will be used to decrypt the
#' ciphertext. Specify the same algorithm that was used to encrypt the
#' data. If you specify a different algorithm, the `Decrypt` operation
#' fails.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric CMK. The default value, `SYMMETRIC_DEFAULT`, represents
#' the only supported algorithm that is valid for symmetric CMKs.
#'
#' @section Request syntax:
#' ```
#' svc$decrypt(
#'   CiphertextBlob = raw,
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   ),
#'   KeyId = "string",
#'   EncryptionAlgorithm = "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example decrypts data that was encrypted with a customer
#' # master key (CMK) in AWS KMS.
#' svc$decrypt(
#'   CiphertextBlob = "<binary data>"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_decrypt
kms_decrypt <- function(CiphertextBlob, EncryptionContext = NULL, GrantTokens = NULL, KeyId = NULL, EncryptionAlgorithm = NULL) {
  op <- new_operation(
    name = "Decrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$decrypt_input(CiphertextBlob = CiphertextBlob, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens, KeyId = KeyId, EncryptionAlgorithm = EncryptionAlgorithm)
  output <- .kms$decrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$decrypt <- kms_decrypt

#' Deletes the specified alias
#'
#' Deletes the specified alias. You cannot perform this operation on an
#' alias in a different AWS account.
#' 
#' Because an alias is not a property of a CMK, you can delete and change
#' the aliases of a CMK without affecting the CMK. Also, aliases do not
#' appear in the response from the DescribeKey operation. To get the
#' aliases of all CMKs, use the ListAliases operation.
#' 
#' Each CMK can have multiple aliases. To change the alias of a CMK, use
#' DeleteAlias to delete the current alias and CreateAlias to create a new
#' alias. To associate an existing alias with a different customer master
#' key (CMK), call UpdateAlias.
#'
#' @usage
#' kms_delete_alias(AliasName)
#'
#' @param AliasName &#91;required&#93; The alias to be deleted. The alias name must begin with `alias/`
#' followed by the alias name, such as `alias/ExampleAlias`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_alias(
#'   AliasName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes the specified alias.
#' svc$delete_alias(
#'   AliasName = "alias/ExampleAlias"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_delete_alias
kms_delete_alias <- function(AliasName) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_alias_input(AliasName = AliasName)
  output <- .kms$delete_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_alias <- kms_delete_alias

#' Deletes a custom key store
#'
#' Deletes a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' This operation does not delete the AWS CloudHSM cluster that is
#' associated with the custom key store, or affect any users or keys in the
#' cluster.
#' 
#' The custom key store that you delete cannot contain any AWS KMS
#' [customer master keys
#' (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
#' Before deleting the key store, verify that you will never need to use
#' any of the CMKs in the key store for any [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
#' Then, use ScheduleKeyDeletion to delete the AWS KMS customer master keys
#' (CMKs) from the key store. When the scheduled waiting period expires,
#' the `ScheduleKeyDeletion` operation deletes the CMKs. Then it makes a
#' best effort to delete the key material from the associated cluster.
#' However, you might need to manually [delete the orphaned key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
#' from the cluster and its backups.
#' 
#' After all CMKs are deleted from AWS KMS, use DisconnectCustomKeyStore to
#' disconnect the key store from AWS KMS. Then, you can delete the custom
#' key store.
#' 
#' Instead of deleting the custom key store, consider using
#' DisconnectCustomKeyStore to disconnect it from AWS KMS. While the key
#' store is disconnected, you cannot create or use the CMKs in the key
#' store. But, you do not need to delete CMKs and you can reconnect a
#' disconnected custom key store at any time.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_delete_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to delete. To find the ID
#' of a custom key store, use the DescribeCustomKeyStores operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_delete_custom_key_store
kms_delete_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DeleteCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$delete_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_custom_key_store <- kms_delete_custom_key_store

#' Deletes key material that you previously imported
#'
#' Deletes key material that you previously imported. This operation makes
#' the specified customer master key (CMK) unusable. For more information
#' about importing key material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*. You cannot perform
#' this operation on a CMK in a different AWS account.
#' 
#' When the specified CMK is in the `PendingDeletion` state, this operation
#' does not change the CMK\'s state. Otherwise, it changes the CMK\'s state
#' to `PendingImport`.
#' 
#' After you delete key material, you can use ImportKeyMaterial to reimport
#' the same key material into the CMK.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_delete_imported_key_material(KeyId)
#'
#' @param KeyId &#91;required&#93; Identifies the CMK from which you are deleting imported key material.
#' The `Origin` of the CMK must be `EXTERNAL`.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$delete_imported_key_material(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes the imported key material from the
#' # specified customer master key (CMK).
#' svc$delete_imported_key_material(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_delete_imported_key_material
kms_delete_imported_key_material <- function(KeyId) {
  op <- new_operation(
    name = "DeleteImportedKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_imported_key_material_input(KeyId = KeyId)
  output <- .kms$delete_imported_key_material_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_imported_key_material <- kms_delete_imported_key_material

#' Gets information about custom key stores in the account and region
#'
#' Gets information about [custom key
#' stores](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' in the account and region.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' 
#' By default, this operation returns information about all custom key
#' stores in the account and region. To get only information about a
#' particular custom key store, use either the `CustomKeyStoreName` or
#' `CustomKeyStoreId` parameter (but not both).
#' 
#' To determine whether the custom key store is connected to its AWS
#' CloudHSM cluster, use the `ConnectionState` element in the response. If
#' an attempt to connect the custom key store failed, the `ConnectionState`
#' value is `FAILED` and the `ConnectionErrorCode` element in the response
#' indicates the cause of the failure. For help interpreting the
#' `ConnectionErrorCode`, see CustomKeyStoresListEntry.
#' 
#' Custom key stores have a `DISCONNECTED` connection state if the key
#' store has never been connected or you use the DisconnectCustomKeyStore
#' operation to disconnect it. If your custom key store state is
#' `CONNECTED` but you are having trouble using it, make sure that its
#' associated AWS CloudHSM cluster is active and contains the minimum
#' number of HSMs required for the operation, if any.
#' 
#' For help repairing your custom key store, see the [Troubleshooting
#' Custom Key
#' Stores](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' topic in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_describe_custom_key_stores(CustomKeyStoreId, CustomKeyStoreName,
#'   Limit, Marker)
#'
#' @param CustomKeyStoreId Gets only information about the specified custom key store. Enter the
#' key store ID.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param CustomKeyStoreName Gets only information about the specified custom key store. Enter the
#' friendly name of the custom key store.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$describe_custom_key_stores(
#'   CustomKeyStoreId = "string",
#'   CustomKeyStoreName = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_describe_custom_key_stores
kms_describe_custom_key_stores <- function(CustomKeyStoreId = NULL, CustomKeyStoreName = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCustomKeyStores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_custom_key_stores_input(CustomKeyStoreId = CustomKeyStoreId, CustomKeyStoreName = CustomKeyStoreName, Limit = Limit, Marker = Marker)
  output <- .kms$describe_custom_key_stores_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_custom_key_stores <- kms_describe_custom_key_stores

#' Provides detailed information about a customer master key (CMK)
#'
#' Provides detailed information about a customer master key (CMK). You can
#' run `DescribeKey` on a [customer managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)
#' or an [AWS managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' 
#' This detailed information includes the key ARN, creation date (and
#' deletion date, if applicable), the key state, and the origin and
#' expiration date (if any) of the key material. For CMKs in custom key
#' stores, it includes information about the custom key store, such as the
#' key store ID and the AWS CloudHSM cluster ID. It includes fields, like
#' `KeySpec`, that help you distinguish symmetric from asymmetric CMKs. It
#' also provides information that is particularly important to asymmetric
#' CMKs, such as the key usage (encryption or signing) and the encryption
#' algorithms or signing algorithms that the CMK supports.
#' 
#' `DescribeKey` does not return the following information:
#' 
#' -   Aliases associated with the CMK. To get this information, use
#'     ListAliases.
#' 
#' -   Whether automatic key rotation is enabled on the CMK. To get this
#'     information, use GetKeyRotationStatus. Also, some key states prevent
#'     a CMK from being automatically rotated. For details, see [How
#'     Automatic Key Rotation
#'     Works](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-how-it-works)
#'     in *AWS Key Management Service Developer Guide*.
#' 
#' -   Tags on the CMK. To get this information, use ListResourceTags.
#' 
#' -   Key policies and grants on the CMK. To get this information, use
#'     GetKeyPolicy and ListGrants.
#' 
#' If you call the `DescribeKey` operation on a *predefined AWS alias*,
#' that is, an AWS alias with no key ID, AWS KMS creates an [AWS managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
#' Then, it associates the alias with the new CMK, and returns the `KeyId`
#' and `Arn` of the new CMK in the response.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN or alias ARN in the value of the KeyId parameter.
#'
#' @usage
#' kms_describe_key(KeyId, GrantTokens)
#'
#' @param KeyId &#91;required&#93; Describes the specified customer master key (CMK).
#' 
#' If you specify a predefined AWS alias (an AWS alias with no key ID), KMS
#' associates the alias with an [AWS managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
#' and returns its `KeyId` and `Arn` in the response.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$describe_key(
#'   KeyId = "string",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns information (metadata) about the specified
#' # CMK.
#' svc$describe_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_describe_key
kms_describe_key <- function(KeyId, GrantTokens = NULL) {
  op <- new_operation(
    name = "DescribeKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_key_input(KeyId = KeyId, GrantTokens = GrantTokens)
  output <- .kms$describe_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_key <- kms_describe_key

#' Sets the state of a customer master key (CMK) to disabled, thereby
#' preventing its use for cryptographic operations
#'
#' Sets the state of a customer master key (CMK) to disabled, thereby
#' preventing its use for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' For more information about how key state affects the use of a CMK, see
#' [How Key State Affects the Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the **AWS Key Management Service Developer Guide** .
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_disable_key(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$disable_key(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example disables the specified CMK.
#' svc$disable_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_disable_key
kms_disable_key <- function(KeyId) {
  op <- new_operation(
    name = "DisableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_input(KeyId = KeyId)
  output <- .kms$disable_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key <- kms_disable_key

#' Disables automatic rotation of the key material for the specified
#' symmetric customer master key (CMK)
#'
#' Disables [automatic rotation of the key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' for the specified symmetric customer master key (CMK).
#' 
#' You cannot enable automatic rotation of asymmetric CMKs, CMKs with
#' imported key material, or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_disable_key_rotation(KeyId)
#'
#' @param KeyId &#91;required&#93; Identifies a symmetric customer master key (CMK). You cannot enable
#' automatic rotation of [asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks),
#' CMKs with [imported key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
#' or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$disable_key_rotation(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example disables automatic annual rotation of the key
#' # material for the specified CMK.
#' svc$disable_key_rotation(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_disable_key_rotation
kms_disable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "DisableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_rotation_input(KeyId = KeyId)
  output <- .kms$disable_key_rotation_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key_rotation <- kms_disable_key_rotation

#' Disconnects the custom key store from its associated AWS CloudHSM
#' cluster
#'
#' Disconnects the [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' from its associated AWS CloudHSM cluster. While a custom key store is
#' disconnected, you can manage the custom key store and its customer
#' master keys (CMKs), but you cannot create or use CMKs in the custom key
#' store. You can reconnect the custom key store at any time.
#' 
#' While a custom key store is disconnected, all attempts to create
#' customer master keys (CMKs) in the custom key store or to use existing
#' CMKs in [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' will fail. This action can prevent users from storing and accessing
#' sensitive data.
#' 
#' To find the connection state of a custom key store, use the
#' DescribeCustomKeyStores operation. To reconnect a custom key store, use
#' the ConnectCustomKeyStore operation.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_disconnect_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to disconnect. To find the
#' ID of a custom key store, use the DescribeCustomKeyStores operation.
#'
#' @section Request syntax:
#' ```
#' svc$disconnect_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_disconnect_custom_key_store
kms_disconnect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DisconnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disconnect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$disconnect_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disconnect_custom_key_store <- kms_disconnect_custom_key_store

#' Sets the key state of a customer master key (CMK) to enabled
#'
#' Sets the key state of a customer master key (CMK) to enabled. This
#' allows you to use the CMK for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_enable_key(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$enable_key(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example enables the specified CMK.
#' svc$enable_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_enable_key
kms_enable_key <- function(KeyId) {
  op <- new_operation(
    name = "EnableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_input(KeyId = KeyId)
  output <- .kms$enable_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key <- kms_enable_key

#' Enables automatic rotation of the key material for the specified
#' symmetric customer master key (CMK)
#'
#' Enables [automatic rotation of the key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' for the specified symmetric customer master key (CMK). You cannot
#' perform this operation on a CMK in a different AWS account.
#' 
#' You cannot enable automatic rotation of asymmetric CMKs, CMKs with
#' imported key material, or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_enable_key_rotation(KeyId)
#'
#' @param KeyId &#91;required&#93; Identifies a symmetric customer master key (CMK). You cannot enable
#' automatic rotation of asymmetric CMKs, CMKs with imported key material,
#' or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$enable_key_rotation(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example enables automatic annual rotation of the key
#' # material for the specified CMK.
#' svc$enable_key_rotation(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_enable_key_rotation
kms_enable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "EnableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_rotation_input(KeyId = KeyId)
  output <- .kms$enable_key_rotation_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key_rotation <- kms_enable_key_rotation

#' Encrypts plaintext into ciphertext by using a customer master key (CMK)
#'
#' Encrypts plaintext into ciphertext by using a customer master key (CMK).
#' The `Encrypt` operation has two primary use cases:
#' 
#' -   You can encrypt small amounts of arbitrary data, such as a personal
#'     identifier or database password, or other sensitive information.
#' 
#' -   You can use the `Encrypt` operation to move encrypted data from one
#'     AWS Region to another. For example, in Region A, generate a data key
#'     and use the plaintext key to encrypt your data. Then, in Region A,
#'     use the `Encrypt` operation to encrypt the plaintext data key under
#'     a CMK in Region B. Now, you can move the encrypted data and the
#'     encrypted data key to Region B. When necessary, you can decrypt the
#'     encrypted data key and the encrypted data entirely within in
#'     Region B.
#' 
#' You don\'t need to use the `Encrypt` operation to encrypt a data key.
#' The GenerateDataKey and GenerateDataKeyPair operations return a
#' plaintext data key and an encrypted copy of that data key.
#' 
#' When you encrypt data, you must specify a symmetric or asymmetric CMK to
#' use in the encryption operation. The CMK must have a `KeyUsage` value of
#' `ENCRYPT_DECRYPT.` To find the `KeyUsage` of a CMK, use the DescribeKey
#' operation.
#' 
#' If you use a symmetric CMK, you can use an encryption context to add
#' additional security to your encryption operation. If you specify an
#' `EncryptionContext` when encrypting data, you must specify the same
#' encryption context (a case-sensitive exact match) when decrypting the
#' data. Otherwise, the request to decrypt fails with an
#' `InvalidCiphertextException`. For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' If you specify an asymmetric CMK, you must also specify the encryption
#' algorithm. The algorithm must be compatible with the CMK type.
#' 
#' When you use an asymmetric CMK to encrypt or reencrypt data, be sure to
#' record the CMK and encryption algorithm that you choose. You will be
#' required to provide the same CMK and encryption algorithm when you
#' decrypt the data. If the CMK and algorithm do not match the values used
#' to encrypt the data, the decrypt operation fails.
#' 
#' You are not required to supply the CMK ID and encryption algorithm when
#' you decrypt with symmetric CMKs because AWS KMS stores this information
#' in the ciphertext blob. AWS KMS cannot store metadata in ciphertext
#' generated with asymmetric keys. The standard format for asymmetric key
#' ciphertext does not include configurable fields.
#' 
#' The maximum size of the data that you can encrypt varies with the type
#' of CMK and the encryption algorithm that you choose.
#' 
#' -   Symmetric CMKs
#' 
#'     -   `SYMMETRIC_DEFAULT`: 4096 bytes
#' 
#' -   `RSA_2048`
#' 
#'     -   `RSAES_OAEP_SHA_1`: 214 bytes
#' 
#'     -   `RSAES_OAEP_SHA_256`: 190 bytes
#' 
#' -   `RSA_3072`
#' 
#'     -   `RSAES_OAEP_SHA_1`: 342 bytes
#' 
#'     -   `RSAES_OAEP_SHA_256`: 318 bytes
#' 
#' -   `RSA_4096`
#' 
#'     -   `RSAES_OAEP_SHA_1`: 470 bytes
#' 
#'     -   `RSAES_OAEP_SHA_256`: 446 bytes
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN or alias ARN in the value of the KeyId parameter.
#'
#' @usage
#' kms_encrypt(KeyId, Plaintext, EncryptionContext, GrantTokens,
#'   EncryptionAlgorithm)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param Plaintext &#91;required&#93; Data to be encrypted.
#' @param EncryptionContext Specifies the encryption context that will be used to encrypt the data.
#' An encryption context is valid only for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' with a symmetric CMK. The standard asymmetric encryption algorithms that
#' AWS KMS uses do not support an encryption context.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#' @param EncryptionAlgorithm Specifies the encryption algorithm that AWS KMS will use to encrypt the
#' plaintext message. The algorithm must be compatible with the CMK that
#' you specify.
#' 
#' This parameter is required only for asymmetric CMKs. The default value,
#' `SYMMETRIC_DEFAULT`, is the algorithm used for symmetric CMKs. If you
#' are using an asymmetric CMK, we recommend RSAES\\_OAEP\\_SHA\\_256.
#'
#' @section Request syntax:
#' ```
#' svc$encrypt(
#'   KeyId = "string",
#'   Plaintext = raw,
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   ),
#'   EncryptionAlgorithm = "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example encrypts data with the specified customer master
#' # key (CMK).
#' svc$encrypt(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Plaintext = "<binary data>"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_encrypt
kms_encrypt <- function(KeyId, Plaintext, EncryptionContext = NULL, GrantTokens = NULL, EncryptionAlgorithm = NULL) {
  op <- new_operation(
    name = "Encrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$encrypt_input(KeyId = KeyId, Plaintext = Plaintext, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens, EncryptionAlgorithm = EncryptionAlgorithm)
  output <- .kms$encrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$encrypt <- kms_encrypt

#' Generates a unique symmetric data key for client-side encryption
#'
#' Generates a unique symmetric data key for client-side encryption. This
#' operation returns a plaintext copy of the data key and a copy that is
#' encrypted under a customer master key (CMK) that you specify. You can
#' use the plaintext key to encrypt your data outside of AWS KMS and store
#' the encrypted data key with the encrypted data.
#' 
#' `GenerateDataKey` returns a unique data key for each request. The bytes
#' in the plaintext key are not related to the caller or the CMK.
#' 
#' To generate a data key, specify the symmetric CMK that will be used to
#' encrypt the data key. You cannot use an asymmetric CMK to generate data
#' keys. To get the type of your CMK, use the DescribeKey operation. You
#' must also specify the length of the data key. Use either the `KeySpec`
#' or `NumberOfBytes` parameters (but not both). For 128-bit and 256-bit
#' data keys, use the `KeySpec` parameter.
#' 
#' To get only an encrypted copy of the data key, use
#' GenerateDataKeyWithoutPlaintext. To generate an asymmetric data key
#' pair, use the GenerateDataKeyPair or GenerateDataKeyPairWithoutPlaintext
#' operation. To get a cryptographically secure random byte string, use
#' GenerateRandom.
#' 
#' You can use the optional encryption context to add additional security
#' to the encryption operation. If you specify an `EncryptionContext`, you
#' must specify the same encryption context (a case-sensitive exact match)
#' when decrypting the encrypted data key. Otherwise, the request to
#' decrypt fails with an `InvalidCiphertextException`. For more
#' information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' **How to use your data key**
#' 
#' We recommend that you use the following pattern to encrypt data locally
#' in your application. You can write your own code or use a client-side
#' encryption library, such as the [AWS Encryption
#' SDK](https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/),
#' the [Amazon DynamoDB Encryption
#' Client](https://docs.aws.amazon.com/dynamodb-encryption-client/latest/devguide/),
#' or [Amazon S3 client-side
#' encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html)
#' to do these tasks for you.
#' 
#' To encrypt data outside of AWS KMS:
#' 
#' 1.  Use the `GenerateDataKey` operation to get a data key.
#' 
#' 2.  Use the plaintext data key (in the `Plaintext` field of the
#'     response) to encrypt your data outside of AWS KMS. Then erase the
#'     plaintext data key from memory.
#' 
#' 3.  Store the encrypted data key (in the `CiphertextBlob` field of the
#'     response) with the encrypted data.
#' 
#' To decrypt data outside of AWS KMS:
#' 
#' 1.  Use the Decrypt operation to decrypt the encrypted data key. The
#'     operation returns a plaintext copy of the data key.
#' 
#' 2.  Use the plaintext data key to decrypt data outside of AWS KMS, then
#'     erase the plaintext data key from memory.
#'
#' @usage
#' kms_generate_data_key(KeyId, EncryptionContext, NumberOfBytes, KeySpec,
#'   GrantTokens)
#'
#' @param KeyId &#91;required&#93; Identifies the symmetric CMK that encrypts the data key.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' data key.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param NumberOfBytes Specifies the length of the data key in bytes. For example, use the
#' value 64 to generate a 512-bit data key (64 bytes is 512 bits). For
#' 128-bit (16-byte) and 256-bit (32-byte) data keys, use the `KeySpec`
#' parameter.
#' 
#' You must specify either the `KeySpec` or the `NumberOfBytes` parameter
#' (but not both) in every `GenerateDataKey` request.
#' @param KeySpec Specifies the length of the data key. Use `AES_128` to generate a
#' 128-bit symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' 
#' You must specify either the `KeySpec` or the `NumberOfBytes` parameter
#' (but not both) in every `GenerateDataKey` request.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key(
#'   KeyId = "string",
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   NumberOfBytes = 123,
#'   KeySpec = "AES_256"|"AES_128",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example generates a 256-bit symmetric data encryption key
#' # (data key) in two formats. One is the unencrypted (plainext) data key,
#' # and the other is the data key encrypted with the specified customer
#' # master key (CMK).
#' svc$generate_data_key(
#'   KeyId = "alias/ExampleAlias",
#'   KeySpec = "AES_256"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key
kms_generate_data_key <- function(KeyId, EncryptionContext = NULL, NumberOfBytes = NULL, KeySpec = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_input(KeyId = KeyId, EncryptionContext = EncryptionContext, NumberOfBytes = NumberOfBytes, KeySpec = KeySpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key <- kms_generate_data_key

#' Generates a unique asymmetric data key pair
#'
#' Generates a unique asymmetric data key pair. The `GenerateDataKeyPair`
#' operation returns a plaintext public key, a plaintext private key, and a
#' copy of the private key that is encrypted under the symmetric CMK you
#' specify. You can use the data key pair to perform asymmetric
#' cryptography outside of AWS KMS.
#' 
#' `GenerateDataKeyPair` returns a unique data key pair for each request.
#' The bytes in the keys are not related to the caller or the CMK that is
#' used to encrypt the private key.
#' 
#' You can use the public key that `GenerateDataKeyPair` returns to encrypt
#' data or verify a signature outside of AWS KMS. Then, store the encrypted
#' private key with the data. When you are ready to decrypt data or sign a
#' message, you can use the Decrypt operation to decrypt the encrypted
#' private key.
#' 
#' To generate a data key pair, you must specify a symmetric customer
#' master key (CMK) to encrypt the private key in a data key pair. You
#' cannot use an asymmetric CMK or a CMK in a custom key store. To get the
#' type and origin of your CMK, use the DescribeKey operation.
#' 
#' If you are using the data key pair to encrypt data, or for any operation
#' where you don\'t immediately need a private key, consider using the
#' GenerateDataKeyPairWithoutPlaintext operation.
#' `GenerateDataKeyPairWithoutPlaintext` returns a plaintext public key and
#' an encrypted private key, but omits the plaintext private key that you
#' need only to decrypt ciphertext or sign a message. Later, when you need
#' to decrypt the data or sign a message, use the Decrypt operation to
#' decrypt the encrypted private key in the data key pair.
#' 
#' You can use the optional encryption context to add additional security
#' to the encryption operation. If you specify an `EncryptionContext`, you
#' must specify the same encryption context (a case-sensitive exact match)
#' when decrypting the encrypted data key. Otherwise, the request to
#' decrypt fails with an `InvalidCiphertextException`. For more
#' information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_generate_data_key_pair(EncryptionContext, KeyId, KeyPairSpec,
#'   GrantTokens)
#'
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' private key in the data key pair.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param KeyId &#91;required&#93; Specifies the symmetric CMK that encrypts the private key in the data
#' key pair. You cannot specify an asymmetric CMK or a CMK in a custom key
#' store. To get the type and origin of your CMK, use the DescribeKey
#' operation.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param KeyPairSpec &#91;required&#93; Determines the type of data key pair that is generated.
#' 
#' The AWS KMS rule that restricts the use of asymmetric RSA CMKs to
#' encrypt and decrypt or to sign and verify (but not both), and the rule
#' that permits you to use ECC CMKs only to sign and verify, are not
#' effective outside of AWS KMS.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key_pair(
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   KeyId = "string",
#'   KeyPairSpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_pair
kms_generate_data_key_pair <- function(EncryptionContext = NULL, KeyId, KeyPairSpec, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_pair_input(EncryptionContext = EncryptionContext, KeyId = KeyId, KeyPairSpec = KeyPairSpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_pair_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_pair <- kms_generate_data_key_pair

#' Generates a unique asymmetric data key pair
#'
#' Generates a unique asymmetric data key pair. The
#' `GenerateDataKeyPairWithoutPlaintext` operation returns a plaintext
#' public key and a copy of the private key that is encrypted under the
#' symmetric CMK you specify. Unlike GenerateDataKeyPair, this operation
#' does not return a plaintext private key.
#' 
#' To generate a data key pair, you must specify a symmetric customer
#' master key (CMK) to encrypt the private key in the data key pair. You
#' cannot use an asymmetric CMK or a CMK in a custom key store. To get the
#' type and origin of your CMK, use the `KeySpec` field in the DescribeKey
#' response.
#' 
#' You can use the public key that `GenerateDataKeyPairWithoutPlaintext`
#' returns to encrypt data or verify a signature outside of AWS KMS. Then,
#' store the encrypted private key with the data. When you are ready to
#' decrypt data or sign a message, you can use the Decrypt operation to
#' decrypt the encrypted private key.
#' 
#' `GenerateDataKeyPairWithoutPlaintext` returns a unique data key pair for
#' each request. The bytes in the key are not related to the caller or CMK
#' that is used to encrypt the private key.
#' 
#' You can use the optional encryption context to add additional security
#' to the encryption operation. If you specify an `EncryptionContext`, you
#' must specify the same encryption context (a case-sensitive exact match)
#' when decrypting the encrypted data key. Otherwise, the request to
#' decrypt fails with an `InvalidCiphertextException`. For more
#' information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_generate_data_key_pair_without_plaintext(EncryptionContext, KeyId,
#'   KeyPairSpec, GrantTokens)
#'
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' private key in the data key pair.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param KeyId &#91;required&#93; Specifies the CMK that encrypts the private key in the data key pair.
#' You must specify a symmetric CMK. You cannot use an asymmetric CMK or a
#' CMK in a custom key store. To get the type and origin of your CMK, use
#' the DescribeKey operation.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param KeyPairSpec &#91;required&#93; Determines the type of data key pair that is generated.
#' 
#' The AWS KMS rule that restricts the use of asymmetric RSA CMKs to
#' encrypt and decrypt or to sign and verify (but not both), and the rule
#' that permits you to use ECC CMKs only to sign and verify, are not
#' effective outside of AWS KMS.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key_pair_without_plaintext(
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   KeyId = "string",
#'   KeyPairSpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_pair_without_plaintext
kms_generate_data_key_pair_without_plaintext <- function(EncryptionContext = NULL, KeyId, KeyPairSpec, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyPairWithoutPlaintext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_pair_without_plaintext_input(EncryptionContext = EncryptionContext, KeyId = KeyId, KeyPairSpec = KeyPairSpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_pair_without_plaintext_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_pair_without_plaintext <- kms_generate_data_key_pair_without_plaintext

#' Generates a unique symmetric data key
#'
#' Generates a unique symmetric data key. This operation returns a data key
#' that is encrypted under a customer master key (CMK) that you specify. To
#' request an asymmetric data key pair, use the GenerateDataKeyPair or
#' GenerateDataKeyPairWithoutPlaintext operations.
#' 
#' `GenerateDataKeyWithoutPlaintext` is identical to the GenerateDataKey
#' operation except that returns only the encrypted copy of the data key.
#' This operation is useful for systems that need to encrypt data at some
#' point, but not immediately. When you need to encrypt the data, you call
#' the Decrypt operation on the encrypted copy of the key.
#' 
#' It\'s also useful in distributed systems with different levels of trust.
#' For example, you might store encrypted data in containers. One component
#' of your system creates new containers and stores an encrypted data key
#' with each container. Then, a different component puts the data into the
#' containers. That component first decrypts the data key, uses the
#' plaintext data key to encrypt data, puts the encrypted data into the
#' container, and then destroys the plaintext data key. In this system, the
#' component that creates the containers never sees the plaintext data key.
#' 
#' `GenerateDataKeyWithoutPlaintext` returns a unique data key for each
#' request. The bytes in the keys are not related to the caller or CMK that
#' is used to encrypt the private key.
#' 
#' To generate a data key, you must specify the symmetric customer master
#' key (CMK) that is used to encrypt the data key. You cannot use an
#' asymmetric CMK to generate a data key. To get the type of your CMK, use
#' the DescribeKey operation.
#' 
#' If the operation succeeds, you will find the encrypted copy of the data
#' key in the `CiphertextBlob` field.
#' 
#' You can use the optional encryption context to add additional security
#' to the encryption operation. If you specify an `EncryptionContext`, you
#' must specify the same encryption context (a case-sensitive exact match)
#' when decrypting the encrypted data key. Otherwise, the request to
#' decrypt fails with an `InvalidCiphertextException`. For more
#' information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_generate_data_key_without_plaintext(KeyId, EncryptionContext,
#'   KeySpec, NumberOfBytes, GrantTokens)
#'
#' @param KeyId &#91;required&#93; The identifier of the symmetric customer master key (CMK) that encrypts
#' the data key.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' data key.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param KeySpec The length of the data key. Use `AES_128` to generate a 128-bit
#' symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' @param NumberOfBytes The length of the data key in bytes. For example, use the value 64 to
#' generate a 512-bit data key (64 bytes is 512 bits). For common key
#' lengths (128-bit and 256-bit symmetric keys), we recommend that you use
#' the `KeySpec` field instead of this one.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key_without_plaintext(
#'   KeyId = "string",
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   KeySpec = "AES_256"|"AES_128",
#'   NumberOfBytes = 123,
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example generates an encrypted copy of a 256-bit symmetric
#' # data encryption key (data key). The data key is encrypted with the
#' # specified customer master key (CMK).
#' svc$generate_data_key_without_plaintext(
#'   KeyId = "alias/ExampleAlias",
#'   KeySpec = "AES_256"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_without_plaintext
kms_generate_data_key_without_plaintext <- function(KeyId, EncryptionContext = NULL, KeySpec = NULL, NumberOfBytes = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyWithoutPlaintext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_without_plaintext_input(KeyId = KeyId, EncryptionContext = EncryptionContext, KeySpec = KeySpec, NumberOfBytes = NumberOfBytes, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_without_plaintext_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_without_plaintext <- kms_generate_data_key_without_plaintext

#' Returns a random byte string that is cryptographically secure
#'
#' Returns a random byte string that is cryptographically secure.
#' 
#' By default, the random byte string is generated in AWS KMS. To generate
#' the byte string in the AWS CloudHSM cluster that is associated with a
#' [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' specify the custom key store ID.
#' 
#' For more information about entropy and random number generation, see the
#' [AWS Key Management Service Cryptographic
#' Details](https://d0.awsstatic.com/whitepapers/KMS-Cryptographic-Details.pdf)
#' whitepaper.
#'
#' @usage
#' kms_generate_random(NumberOfBytes, CustomKeyStoreId)
#'
#' @param NumberOfBytes The length of the byte string.
#' @param CustomKeyStoreId Generates the random byte string in the AWS CloudHSM cluster that is
#' associated with the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$generate_random(
#'   NumberOfBytes = 123,
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example uses AWS KMS to generate 32 bytes of random data.
#' svc$generate_random(
#'   NumberOfBytes = 32L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_generate_random
kms_generate_random <- function(NumberOfBytes = NULL, CustomKeyStoreId = NULL) {
  op <- new_operation(
    name = "GenerateRandom",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_random_input(NumberOfBytes = NumberOfBytes, CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$generate_random_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_random <- kms_generate_random

#' Gets a key policy attached to the specified customer master key (CMK)
#'
#' Gets a key policy attached to the specified customer master key (CMK).
#' You cannot perform this operation on a CMK in a different AWS account.
#'
#' @usage
#' kms_get_key_policy(KeyId, PolicyName)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PolicyName &#91;required&#93; Specifies the name of the key policy. The only valid name is `default`.
#' To get the names of key policies, use ListKeyPolicies.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_policy(
#'   KeyId = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example retrieves the key policy for the specified
#' # customer master key (CMK).
#' svc$get_key_policy(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   PolicyName = "default"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_get_key_policy
kms_get_key_policy <- function(KeyId, PolicyName) {
  op <- new_operation(
    name = "GetKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_policy_input(KeyId = KeyId, PolicyName = PolicyName)
  output <- .kms$get_key_policy_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_policy <- kms_get_key_policy

#' Gets a Boolean value that indicates whether automatic rotation of the
#' key material is enabled for the specified customer master key (CMK)
#'
#' Gets a Boolean value that indicates whether [automatic rotation of the
#' key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' is enabled for the specified customer master key (CMK).
#' 
#' You cannot enable automatic rotation of asymmetric CMKs, CMKs with
#' imported key material, or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' The key rotation status for these CMKs is always `false`.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' -   Disabled: The key rotation status does not change when you disable a
#'     CMK. However, while the CMK is disabled, AWS KMS does not rotate the
#'     backing key.
#' 
#' -   Pending deletion: While a CMK is pending deletion, its key rotation
#'     status is `false` and AWS KMS does not rotate the backing key. If
#'     you cancel the deletion, the original key rotation status is
#'     restored.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#'
#' @usage
#' kms_get_key_rotation_status(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_rotation_status(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example retrieves the status of automatic annual rotation
#' # of the key material for the specified CMK.
#' svc$get_key_rotation_status(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_get_key_rotation_status
kms_get_key_rotation_status <- function(KeyId) {
  op <- new_operation(
    name = "GetKeyRotationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_rotation_status_input(KeyId = KeyId)
  output <- .kms$get_key_rotation_status_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_rotation_status <- kms_get_key_rotation_status

#' Returns the items you need to import key material into a symmetric,
#' customer managed customer master key (CMK)
#'
#' Returns the items you need to import key material into a symmetric,
#' customer managed customer master key (CMK). For more information about
#' importing key material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' This operation returns a public key and an import token. Use the public
#' key to encrypt the symmetric key material. Store the import token to
#' send with a subsequent ImportKeyMaterial request.
#' 
#' You must specify the key ID of the symmetric CMK into which you will
#' import key material. This CMK\'s `Origin` must be `EXTERNAL`. You must
#' also specify the wrapping algorithm and type of wrapping key (public
#' key) that you will use to encrypt the key material. You cannot perform
#' this operation on an asymmetric CMK or on any CMK in a different AWS
#' account.
#' 
#' To import key material, you must use the public key and import token
#' from the same response. These items are valid for 24 hours. The
#' expiration date and time appear in the `GetParametersForImport`
#' response. You cannot use an expired token in an ImportKeyMaterial
#' request. If your key and token expire, send another
#' `GetParametersForImport` request.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_get_parameters_for_import(KeyId, WrappingAlgorithm, WrappingKeySpec)
#'
#' @param KeyId &#91;required&#93; The identifier of the symmetric CMK into which you will import key
#' material. The `Origin` of the CMK must be `EXTERNAL`.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param WrappingAlgorithm &#91;required&#93; The algorithm you will use to encrypt the key material before importing
#' it with ImportKeyMaterial. For more information, see [Encrypt the Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
#' in the *AWS Key Management Service Developer Guide*.
#' @param WrappingKeySpec &#91;required&#93; The type of wrapping key (public key) to return in the response. Only
#' 2048-bit RSA public keys are supported.
#'
#' @section Request syntax:
#' ```
#' svc$get_parameters_for_import(
#'   KeyId = "string",
#'   WrappingAlgorithm = "RSAES_PKCS1_V1_5"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256",
#'   WrappingKeySpec = "RSA_2048"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example retrieves the public key and import token for the
#' # specified CMK.
#' svc$get_parameters_for_import(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   WrappingAlgorithm = "RSAES_OAEP_SHA_1",
#'   WrappingKeySpec = "RSA_2048"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_get_parameters_for_import
kms_get_parameters_for_import <- function(KeyId, WrappingAlgorithm, WrappingKeySpec) {
  op <- new_operation(
    name = "GetParametersForImport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_parameters_for_import_input(KeyId = KeyId, WrappingAlgorithm = WrappingAlgorithm, WrappingKeySpec = WrappingKeySpec)
  output <- .kms$get_parameters_for_import_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_parameters_for_import <- kms_get_parameters_for_import

#' Returns the public key of an asymmetric CMK
#'
#' Returns the public key of an asymmetric CMK. Unlike the private key of a
#' asymmetric CMK, which never leaves AWS KMS unencrypted, callers with
#' `kms:GetPublicKey` permission can download the public key of an
#' asymmetric CMK. You can share the public key to allow others to encrypt
#' messages and verify signatures outside of AWS KMS. For information about
#' symmetric and asymmetric CMKs, see [Using Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' You do not need to download the public key. Instead, you can use the
#' public key within AWS KMS by calling the Encrypt, ReEncrypt, or Verify
#' operations with the identifier of an asymmetric CMK. When you use the
#' public key within AWS KMS, you benefit from the authentication,
#' authorization, and logging that are part of every AWS KMS operation. You
#' also reduce of risk of encrypting data that cannot be decrypted. These
#' features are not effective outside of AWS KMS. For details, see [Special
#' Considerations for Downloading Public
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/download-public-key.html#download-public-key-considerations).
#' 
#' To help you use the public key safely outside of AWS KMS, `GetPublicKey`
#' returns important information about the public key in the response,
#' including:
#' 
#' -   [CustomerMasterKeySpec](https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-CustomerMasterKeySpec):
#'     The type of key material in the public key, such as `RSA_4096` or
#'     `ECC_NIST_P521`.
#' 
#' -   [KeyUsage](https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-KeyUsage):
#'     Whether the key is used for encryption or signing.
#' 
#' -   [EncryptionAlgorithms](https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-EncryptionAlgorithms)
#'     or
#'     [SigningAlgorithms](https://docs.aws.amazon.com/kms/latest/APIReference/API_GetPublicKey.html#KMS-GetPublicKey-response-SigningAlgorithms):
#'     A list of the encryption algorithms or the signing algorithms for
#'     the key.
#' 
#' Although AWS KMS cannot enforce these restrictions on external
#' operations, it is crucial that you use this information to prevent the
#' public key from being used improperly. For example, you can prevent a
#' public signing key from being used encrypt data, or prevent a public key
#' from being used with an encryption algorithm that is not supported by
#' AWS KMS. You can also avoid errors, such as using the wrong signing
#' algorithm in a verification operation.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_get_public_key(KeyId, GrantTokens)
#'
#' @param KeyId &#91;required&#93; Identifies the asymmetric CMK that includes the public key.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_key(
#'   KeyId = "string",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_get_public_key
kms_get_public_key <- function(KeyId, GrantTokens = NULL) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_public_key_input(KeyId = KeyId, GrantTokens = GrantTokens)
  output <- .kms$get_public_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_public_key <- kms_get_public_key

#' Imports key material into an existing symmetric AWS KMS customer master
#' key (CMK) that was created without key material
#'
#' Imports key material into an existing symmetric AWS KMS customer master
#' key (CMK) that was created without key material. After you successfully
#' import key material into a CMK, you can [reimport the same key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material)
#' into that CMK, but you cannot import different key material.
#' 
#' You cannot perform this operation on an asymmetric CMK or on any CMK in
#' a different AWS account. For more information about creating CMKs with
#' no key material and then importing key material, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' Before using this operation, call GetParametersForImport. Its response
#' includes a public key and an import token. Use the public key to encrypt
#' the key material. Then, submit the import token from the same
#' `GetParametersForImport` response.
#' 
#' When calling this operation, you must specify the following values:
#' 
#' -   The key ID or key ARN of a CMK with no key material. Its `Origin`
#'     must be `EXTERNAL`.
#' 
#'     To create a CMK with no key material, call CreateKey and set the
#'     value of its `Origin` parameter to `EXTERNAL`. To get the `Origin`
#'     of a CMK, call DescribeKey.)
#' 
#' -   The encrypted key material. To get the public key to encrypt the key
#'     material, call GetParametersForImport.
#' 
#' -   The import token that GetParametersForImport returned. You must use
#'     a public key and token from the same `GetParametersForImport`
#'     response.
#' 
#' -   Whether the key material expires and if so, when. If you set an
#'     expiration date, AWS KMS deletes the key material from the CMK on
#'     the specified date, and the CMK becomes unusable. To use the CMK
#'     again, you must reimport the same key material. The only way to
#'     change an expiration date is by reimporting the same key material
#'     and specifying a new expiration date.
#' 
#' When this operation is successful, the key state of the CMK changes from
#' `PendingImport` to `Enabled`, and you can use the CMK.
#' 
#' If this operation fails, use the exception to help determine the
#' problem. If the error is related to the key material, the import token,
#' or wrapping key, use GetParametersForImport to get a new public key and
#' import token for the CMK and repeat the import procedure. For help, see
#' [How To Import Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#importing-keys-overview)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_import_key_material(KeyId, ImportToken, EncryptedKeyMaterial,
#'   ValidTo, ExpirationModel)
#'
#' @param KeyId &#91;required&#93; The identifier of the symmetric CMK that receives the imported key
#' material. The CMK\'s `Origin` must be `EXTERNAL`. This must be the same
#' CMK specified in the `KeyID` parameter of the corresponding
#' GetParametersForImport request.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param ImportToken &#91;required&#93; The import token that you received in the response to a previous
#' GetParametersForImport request. It must be from the same response that
#' contained the public key that you used to encrypt the key material.
#' @param EncryptedKeyMaterial &#91;required&#93; The encrypted key material to import. The key material must be encrypted
#' with the public wrapping key that GetParametersForImport returned, using
#' the wrapping algorithm that you specified in the same
#' `GetParametersForImport` request.
#' @param ValidTo The time at which the imported key material expires. When the key
#' material expires, AWS KMS deletes the key material and the CMK becomes
#' unusable. You must omit this parameter when the `ExpirationModel`
#' parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`. Otherwise it is
#' required.
#' @param ExpirationModel Specifies whether the key material expires. The default is
#' `KEY_MATERIAL_EXPIRES`, in which case you must include the `ValidTo`
#' parameter. When this parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`,
#' you must omit the `ValidTo` parameter.
#'
#' @section Request syntax:
#' ```
#' svc$import_key_material(
#'   KeyId = "string",
#'   ImportToken = raw,
#'   EncryptedKeyMaterial = raw,
#'   ValidTo = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ExpirationModel = "KEY_MATERIAL_EXPIRES"|"KEY_MATERIAL_DOES_NOT_EXPIRE"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example imports key material into the specified CMK.
#' svc$import_key_material(
#'   EncryptedKeyMaterial = "<binary data>",
#'   ExpirationModel = "KEY_MATERIAL_DOES_NOT_EXPIRE",
#'   ImportToken = "<binary data>",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_import_key_material
kms_import_key_material <- function(KeyId, ImportToken, EncryptedKeyMaterial, ValidTo = NULL, ExpirationModel = NULL) {
  op <- new_operation(
    name = "ImportKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$import_key_material_input(KeyId = KeyId, ImportToken = ImportToken, EncryptedKeyMaterial = EncryptedKeyMaterial, ValidTo = ValidTo, ExpirationModel = ExpirationModel)
  output <- .kms$import_key_material_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$import_key_material <- kms_import_key_material

#' Gets a list of aliases in the caller's AWS account and region
#'
#' Gets a list of aliases in the caller\'s AWS account and region. You
#' cannot list aliases in other accounts. For more information about
#' aliases, see CreateAlias.
#' 
#' By default, the ListAliases command returns all aliases in the account
#' and region. To get only the aliases that point to a particular customer
#' master key (CMK), use the `KeyId` parameter.
#' 
#' The `ListAliases` response can include aliases that you created and
#' associated with your customer managed CMKs, and aliases that AWS created
#' and associated with AWS managed CMKs in your account. You can recognize
#' AWS aliases because their names have the format
#' `aws/&lt;service-name&gt;`, such as `aws/dynamodb`.
#' 
#' The response might also include aliases that have no `TargetKeyId`
#' field. These are predefined aliases that AWS has created but has not yet
#' associated with a CMK. Aliases that AWS creates in your account,
#' including predefined aliases, do not count against your [AWS KMS aliases
#' quota](https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit).
#'
#' @usage
#' kms_list_aliases(KeyId, Limit, Marker)
#'
#' @param KeyId Lists only aliases that refer to the specified CMK. The value of this
#' parameter can be the ID or Amazon Resource Name (ARN) of a CMK in the
#' caller\'s account and region. You cannot use an alias name or alias ARN
#' in this value.
#' 
#' This parameter is optional. If you omit it, `ListAliases` returns all
#' aliases in the account and region.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_aliases(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists aliases.
#' svc$list_aliases()
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_aliases
kms_list_aliases <- function(KeyId = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_aliases_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_aliases_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_aliases <- kms_list_aliases

#' Gets a list of all grants for the specified customer master key (CMK)
#'
#' Gets a list of all grants for the specified customer master key (CMK).
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#' 
#' The `GranteePrincipal` field in the `ListGrants` response usually
#' contains the user or role designated as the grantee principal in the
#' grant. However, when the grantee principal in the grant is an AWS
#' service, the `GranteePrincipal` field contains the [service
#' principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services),
#' which might represent several different grantee principals.
#'
#' @usage
#' kms_list_grants(Limit, Marker, KeyId)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$list_grants(
#'   Limit = 123,
#'   Marker = "string",
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists grants for the specified CMK.
#' svc$list_grants(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_grants
kms_list_grants <- function(Limit = NULL, Marker = NULL, KeyId) {
  op <- new_operation(
    name = "ListGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_grants_input(Limit = Limit, Marker = Marker, KeyId = KeyId)
  output <- .kms$list_grants_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_grants <- kms_list_grants

#' Gets the names of the key policies that are attached to a customer
#' master key (CMK)
#'
#' Gets the names of the key policies that are attached to a customer
#' master key (CMK). This operation is designed to get policy names that
#' you can use in a GetKeyPolicy operation. However, the only valid policy
#' name is `default`. You cannot perform this operation on a CMK in a
#' different AWS account.
#'
#' @usage
#' kms_list_key_policies(KeyId, Limit, Marker)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' 
#' Only one policy can be attached to a key.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_key_policies(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists key policies for the specified CMK.
#' svc$list_key_policies(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_key_policies
kms_list_key_policies <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeyPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_key_policies_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_key_policies_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_key_policies <- kms_list_key_policies

#' Gets a list of all customer master keys (CMKs) in the caller's AWS
#' account and Region
#'
#' Gets a list of all customer master keys (CMKs) in the caller\'s AWS
#' account and Region.
#'
#' @usage
#' kms_list_keys(Limit, Marker)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_keys(
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists CMKs.
#' svc$list_keys()
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_keys
kms_list_keys <- function(Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_keys_input(Limit = Limit, Marker = Marker)
  output <- .kms$list_keys_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_keys <- kms_list_keys

#' Returns a list of all tags for the specified customer master key (CMK)
#'
#' Returns a list of all tags for the specified customer master key (CMK).
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#'
#' @usage
#' kms_list_resource_tags(KeyId, Limit, Marker)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 50, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' 
#' Do not attempt to construct this value. Use only the value of
#' `NextMarker` from the truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_tags(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists tags for a CMK.
#' svc$list_resource_tags(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_resource_tags
kms_list_resource_tags <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListResourceTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_resource_tags_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_resource_tags_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_resource_tags <- kms_list_resource_tags

#' Returns a list of all grants for which the grant's RetiringPrincipal
#' matches the one specified
#'
#' Returns a list of all grants for which the grant\'s `RetiringPrincipal`
#' matches the one specified.
#' 
#' A typical use is to list all grants that you are able to retire. To
#' retire a grant, use RetireGrant.
#'
#' @usage
#' kms_list_retirable_grants(Limit, Marker, RetiringPrincipal)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param RetiringPrincipal &#91;required&#93; The retiring principal for which to list grants.
#' 
#' To specify the retiring principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, federated users, and assumed role users. For examples of the
#' ARN syntax for specifying a principal, see [AWS Identity and Access
#' Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *Amazon Web Services General
#' Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$list_retirable_grants(
#'   Limit = 123,
#'   Marker = "string",
#'   RetiringPrincipal = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example lists the grants that the specified principal
#' # (identity) can retire.
#' svc$list_retirable_grants(
#'   RetiringPrincipal = "arn:aws:iam::111122223333:role/ExampleRole"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_list_retirable_grants
kms_list_retirable_grants <- function(Limit = NULL, Marker = NULL, RetiringPrincipal) {
  op <- new_operation(
    name = "ListRetirableGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_retirable_grants_input(Limit = Limit, Marker = Marker, RetiringPrincipal = RetiringPrincipal)
  output <- .kms$list_retirable_grants_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_retirable_grants <- kms_list_retirable_grants

#' Attaches a key policy to the specified customer master key (CMK)
#'
#' Attaches a key policy to the specified customer master key (CMK). You
#' cannot perform this operation on a CMK in a different AWS account.
#' 
#' For more information about key policies, see [Key
#' Policies](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_put_key_policy(KeyId, PolicyName, Policy,
#'   BypassPolicyLockoutSafetyCheck)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PolicyName &#91;required&#93; The name of the key policy. The only valid value is `default`.
#' @param Policy &#91;required&#93; The key policy to attach to the CMK.
#' 
#' The key policy must meet the following criteria:
#' 
#' -   If you don\'t set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must allow the principal that is making the `PutKeyPolicy`
#'     request to make a subsequent `PutKeyPolicy` request on the CMK. This
#'     reduces the risk that the CMK becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the *AWS Key Management Service Developer Guide*.
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to AWS KMS. When you create a new AWS principal (for
#'     example, an IAM user or role), you might need to enforce a delay
#'     before including the new principal in a key policy because the new
#'     principal might not be immediately visible to AWS KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *AWS Identity and Access Management User Guide*.
#' 
#' The key policy cannot exceed 32 kilobytes (32768 bytes). For more
#' information, see [Resource
#' Quotas](https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html)
#' in the *AWS Key Management Service Developer Guide*.
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the CMK becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the *AWS Key Management Service Developer Guide*.
#' 
#' Use this parameter only when you intend to prevent the principal that is
#' making the request from making a subsequent `PutKeyPolicy` request on
#' the CMK.
#' 
#' The default value is false.
#'
#' @section Request syntax:
#' ```
#' svc$put_key_policy(
#'   KeyId = "string",
#'   PolicyName = "string",
#'   Policy = "string",
#'   BypassPolicyLockoutSafetyCheck = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example attaches a key policy to the specified CMK.
#' svc$put_key_policy(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Policy = "\{\n    \"Version\": \"2012-10-17\",\n    \"Id\": \"custom-policy-2016-12-07\",\n...",
#'   PolicyName = "default"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_put_key_policy
kms_put_key_policy <- function(KeyId, PolicyName, Policy, BypassPolicyLockoutSafetyCheck = NULL) {
  op <- new_operation(
    name = "PutKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$put_key_policy_input(KeyId = KeyId, PolicyName = PolicyName, Policy = Policy, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck)
  output <- .kms$put_key_policy_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$put_key_policy <- kms_put_key_policy

#' Decrypts ciphertext and then reencrypts it entirely within AWS KMS
#'
#' Decrypts ciphertext and then reencrypts it entirely within AWS KMS. You
#' can use this operation to change the customer master key (CMK) under
#' which data is encrypted, such as when you [manually
#' rotate](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-manually)
#' a CMK or change the CMK that protects a ciphertext. You can also use it
#' to reencrypt ciphertext under the same CMK, such as to change the
#' [encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' of a ciphertext.
#' 
#' The `ReEncrypt` operation can decrypt ciphertext that was encrypted by
#' using an AWS KMS CMK in an AWS KMS operation, such as Encrypt or
#' GenerateDataKey. It can also decrypt ciphertext that was encrypted by
#' using the public key of an [asymmetric
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html#asymmetric-cmks)
#' outside of AWS KMS. However, it cannot decrypt ciphertext produced by
#' other libraries, such as the [AWS Encryption
#' SDK](https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/)
#' or [Amazon S3 client-side
#' encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
#' These libraries return a ciphertext format that is incompatible with AWS
#' KMS.
#' 
#' When you use the `ReEncrypt` operation, you need to provide information
#' for the decrypt operation and the subsequent encrypt operation.
#' 
#' -   If your ciphertext was encrypted under an asymmetric CMK, you must
#'     identify the *source CMK*, that is, the CMK that encrypted the
#'     ciphertext. You must also supply the encryption algorithm that was
#'     used. This information is required to decrypt the data.
#' 
#' -   It is optional, but you can specify a source CMK even when the
#'     ciphertext was encrypted under a symmetric CMK. This ensures that
#'     the ciphertext is decrypted only by using a particular CMK. If the
#'     CMK that you specify cannot decrypt the ciphertext, the `ReEncrypt`
#'     operation fails.
#' 
#' -   To reencrypt the data, you must specify the *destination CMK*, that
#'     is, the CMK that re-encrypts the data after it is decrypted. You can
#'     select a symmetric or asymmetric CMK. If the destination CMK is an
#'     asymmetric CMK, you must also provide the encryption algorithm. The
#'     algorithm that you choose must be compatible with the CMK.
#' 
#'     When you use an asymmetric CMK to encrypt or reencrypt data, be sure
#'     to record the CMK and encryption algorithm that you choose. You will
#'     be required to provide the same CMK and encryption algorithm when
#'     you decrypt the data. If the CMK and algorithm do not match the
#'     values used to encrypt the data, the decrypt operation fails.
#' 
#'     You are not required to supply the CMK ID and encryption algorithm
#'     when you decrypt with symmetric CMKs because AWS KMS stores this
#'     information in the ciphertext blob. AWS KMS cannot store metadata in
#'     ciphertext generated with asymmetric keys. The standard format for
#'     asymmetric key ciphertext does not include configurable fields.
#' 
#' Unlike other AWS KMS API operations, `ReEncrypt` callers must have two
#' permissions:
#' 
#' -   `kms:ReEncryptFrom` permission on the source CMK
#' 
#' -   `kms:ReEncryptTo` permission on the destination CMK
#' 
#' To permit reencryption from or to a CMK, include the `"kms:ReEncrypt*"`
#' permission in your [key
#' policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html).
#' This permission is automatically included in the key policy when you use
#' the console to create a CMK. But you must include it manually when you
#' create a CMK programmatically or when you use the PutKeyPolicy operation
#' to set a key policy.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_re_encrypt(CiphertextBlob, SourceEncryptionContext, SourceKeyId,
#'   DestinationKeyId, DestinationEncryptionContext,
#'   SourceEncryptionAlgorithm, DestinationEncryptionAlgorithm, GrantTokens)
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext of the data to reencrypt.
#' @param SourceEncryptionContext Specifies the encryption context to use to decrypt the ciphertext. Enter
#' the same encryption context that was used to encrypt the ciphertext.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param SourceKeyId A unique identifier for the CMK that is used to decrypt the ciphertext
#' before it reencrypts it using the destination CMK.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric CMK. Otherwise, AWS KMS uses the metadata that it adds to
#' the ciphertext blob to determine which CMK was used to encrypt the
#' ciphertext. However, you can use this parameter to ensure that a
#' particular CMK (of any kind) is used to decrypt the ciphertext before it
#' is reencrypted.
#' 
#' If you specify a `KeyId` value, the decrypt part of the `ReEncrypt`
#' operation succeeds only if the specified CMK was used to encrypt the
#' ciphertext.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param DestinationKeyId &#91;required&#93; A unique identifier for the CMK that is used to reencrypt the data.
#' Specify a symmetric or asymmetric CMK with a `KeyUsage` value of
#' `ENCRYPT_DECRYPT`. To find the `KeyUsage` value of a CMK, use the
#' DescribeKey operation.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param DestinationEncryptionContext Specifies that encryption context to use when the reencrypting the data.
#' 
#' A destination encryption context is valid only when the destination CMK
#' is a symmetric CMK. The standard ciphertext format for asymmetric CMKs
#' does not include fields for metadata.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represents additional authenticated data. When you use an
#' encryption context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is optional when encrypting with a symmetric CMK, but
#' it is highly recommended.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param SourceEncryptionAlgorithm Specifies the encryption algorithm that AWS KMS will use to decrypt the
#' ciphertext before it is reencrypted. The default value,
#' `SYMMETRIC_DEFAULT`, represents the algorithm used for symmetric CMKs.
#' 
#' Specify the same algorithm that was used to encrypt the ciphertext. If
#' you specify a different algorithm, the decrypt attempt fails.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric CMK.
#' @param DestinationEncryptionAlgorithm Specifies the encryption algorithm that AWS KMS will use to reecrypt the
#' data after it has decrypted it. The default value, `SYMMETRIC_DEFAULT`,
#' represents the encryption algorithm used for symmetric CMKs.
#' 
#' This parameter is required only when the destination CMK is an
#' asymmetric CMK.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$re_encrypt(
#'   CiphertextBlob = raw,
#'   SourceEncryptionContext = list(
#'     "string"
#'   ),
#'   SourceKeyId = "string",
#'   DestinationKeyId = "string",
#'   DestinationEncryptionContext = list(
#'     "string"
#'   ),
#'   SourceEncryptionAlgorithm = "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256",
#'   DestinationEncryptionAlgorithm = "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example reencrypts data with the specified CMK.
#' svc$re_encrypt(
#'   CiphertextBlob = "<binary data>",
#'   DestinationKeyId = "0987dcba-09fe-87dc-65ba-ab0987654321"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_re_encrypt
kms_re_encrypt <- function(CiphertextBlob, SourceEncryptionContext = NULL, SourceKeyId = NULL, DestinationKeyId, DestinationEncryptionContext = NULL, SourceEncryptionAlgorithm = NULL, DestinationEncryptionAlgorithm = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "ReEncrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$re_encrypt_input(CiphertextBlob = CiphertextBlob, SourceEncryptionContext = SourceEncryptionContext, SourceKeyId = SourceKeyId, DestinationKeyId = DestinationKeyId, DestinationEncryptionContext = DestinationEncryptionContext, SourceEncryptionAlgorithm = SourceEncryptionAlgorithm, DestinationEncryptionAlgorithm = DestinationEncryptionAlgorithm, GrantTokens = GrantTokens)
  output <- .kms$re_encrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$re_encrypt <- kms_re_encrypt

#' Retires a grant
#'
#' Retires a grant. To clean up, you can retire a grant when you\'re done
#' using it. You should revoke a grant when you intend to actively deny
#' operations that depend on it. The following are permitted to call this
#' API:
#' 
#' -   The AWS account (root user) under which the grant was created
#' 
#' -   The `RetiringPrincipal`, if present in the grant
#' 
#' -   The `GranteePrincipal`, if `RetireGrant` is an operation specified
#'     in the grant
#' 
#' You must identify the grant to retire by its grant token or by a
#' combination of the grant ID and the Amazon Resource Name (ARN) of the
#' customer master key (CMK). A grant token is a unique variable-length
#' base64-encoded string. A grant ID is a 64 character unique identifier of
#' a grant. The CreateGrant operation returns both.
#'
#' @usage
#' kms_retire_grant(GrantToken, KeyId, GrantId)
#'
#' @param GrantToken Token that identifies the grant to be retired.
#' @param KeyId The Amazon Resource Name (ARN) of the CMK associated with the grant.
#' 
#' For example:
#' `arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' @param GrantId Unique identifier of the grant to retire. The grant ID is returned in
#' the response to a `CreateGrant` operation.
#' 
#' -   Grant ID Example -
#'     0123456789012345678901234567890123456789012345678901234567890123
#'
#' @section Request syntax:
#' ```
#' svc$retire_grant(
#'   GrantToken = "string",
#'   KeyId = "string",
#'   GrantId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example retires a grant.
#' svc$retire_grant(
#'   GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
#'   KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_retire_grant
kms_retire_grant <- function(GrantToken = NULL, KeyId = NULL, GrantId = NULL) {
  op <- new_operation(
    name = "RetireGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$retire_grant_input(GrantToken = GrantToken, KeyId = KeyId, GrantId = GrantId)
  output <- .kms$retire_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$retire_grant <- kms_retire_grant

#' Revokes the specified grant for the specified customer master key (CMK)
#'
#' Revokes the specified grant for the specified customer master key (CMK).
#' You can revoke a grant to actively deny operations that depend on it.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#'
#' @usage
#' kms_revoke_grant(KeyId, GrantId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key associated with the
#' grant.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param GrantId &#91;required&#93; Identifier of the grant to be revoked.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_grant(
#'   KeyId = "string",
#'   GrantId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example revokes a grant.
#' svc$revoke_grant(
#'   GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_revoke_grant
kms_revoke_grant <- function(KeyId, GrantId) {
  op <- new_operation(
    name = "RevokeGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$revoke_grant_input(KeyId = KeyId, GrantId = GrantId)
  output <- .kms$revoke_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$revoke_grant <- kms_revoke_grant

#' Schedules the deletion of a customer master key (CMK)
#'
#' Schedules the deletion of a customer master key (CMK). You may provide a
#' waiting period, specified in days, before deletion occurs. If you do not
#' provide a waiting period, the default period of 30 days is used. When
#' this operation is successful, the key state of the CMK changes to
#' `PendingDeletion`. Before the waiting period ends, you can use
#' CancelKeyDeletion to cancel the deletion of the CMK. After the waiting
#' period ends, AWS KMS deletes the CMK and all AWS KMS data associated
#' with it, including all aliases that refer to it.
#' 
#' Deleting a CMK is a destructive and potentially dangerous operation.
#' When a CMK is deleted, all data that was encrypted under the CMK is
#' unrecoverable. To prevent the use of a CMK without deleting it, use
#' DisableKey.
#' 
#' If you schedule deletion of a CMK from a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' when the waiting period expires, `ScheduleKeyDeletion` deletes the CMK
#' from AWS KMS. Then AWS KMS makes a best effort to delete the key
#' material from the associated AWS CloudHSM cluster. However, you might
#' need to manually [delete the orphaned key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
#' from the cluster and its backups.
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' For more information about scheduling a CMK for deletion, see [Deleting
#' Customer Master
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_schedule_key_deletion(KeyId, PendingWindowInDays)
#'
#' @param KeyId &#91;required&#93; The unique identifier of the customer master key (CMK) to delete.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PendingWindowInDays The waiting period, specified in number of days. After the waiting
#' period ends, AWS KMS deletes the customer master key (CMK).
#' 
#' This value is optional. If you include a value, it must be between 7 and
#' 30, inclusive. If you do not include a value, it defaults to 30.
#'
#' @section Request syntax:
#' ```
#' svc$schedule_key_deletion(
#'   KeyId = "string",
#'   PendingWindowInDays = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example schedules the specified CMK for deletion.
#' svc$schedule_key_deletion(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   PendingWindowInDays = 7L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_schedule_key_deletion
kms_schedule_key_deletion <- function(KeyId, PendingWindowInDays = NULL) {
  op <- new_operation(
    name = "ScheduleKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$schedule_key_deletion_input(KeyId = KeyId, PendingWindowInDays = PendingWindowInDays)
  output <- .kms$schedule_key_deletion_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$schedule_key_deletion <- kms_schedule_key_deletion

#' Creates a digital signature for a message or message digest by using the
#' private key in an asymmetric CMK
#'
#' Creates a [digital
#' signature](https://en.wikipedia.org/wiki/Digital_signature) for a
#' message or message digest by using the private key in an asymmetric CMK.
#' To verify the signature, use the Verify operation, or use the public key
#' in the same asymmetric CMK outside of AWS KMS. For information about
#' symmetric and asymmetric CMKs, see [Using Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' Digital signatures are generated and verified by using asymmetric key
#' pair, such as an RSA or ECC pair that is represented by an asymmetric
#' customer master key (CMK). The key owner (or an authorized user) uses
#' their private key to sign a message. Anyone with the public key can
#' verify that the message was signed with that particular private key and
#' that the message hasn\'t changed since it was signed.
#' 
#' To use the `Sign` operation, provide the following information:
#' 
#' -   Use the `KeyId` parameter to identify an asymmetric CMK with a
#'     `KeyUsage` value of `SIGN_VERIFY`. To get the `KeyUsage` value of a
#'     CMK, use the DescribeKey operation. The caller must have `kms:Sign`
#'     permission on the CMK.
#' 
#' -   Use the `Message` parameter to specify the message or message digest
#'     to sign. You can submit messages of up to 4096 bytes. To sign a
#'     larger message, generate a hash digest of the message, and then
#'     provide the hash digest in the `Message` parameter. To indicate
#'     whether the message is a full message or a digest, use the
#'     `MessageType` parameter.
#' 
#' -   Choose a signing algorithm that is compatible with the CMK.
#' 
#' When signing a message, be sure to record the CMK and the signing
#' algorithm. This information is required to verify the signature.
#' 
#' To verify the signature that this operation generates, use the Verify
#' operation. Or use the GetPublicKey operation to download the public key
#' and then use the public key to verify the signature outside of AWS KMS.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_sign(KeyId, Message, MessageType, GrantTokens, SigningAlgorithm)
#'
#' @param KeyId &#91;required&#93; Identifies an asymmetric CMK. AWS KMS uses the private key in the
#' asymmetric CMK to sign the message. The `KeyUsage` type of the CMK must
#' be `SIGN_VERIFY`. To find the `KeyUsage` of a CMK, use the DescribeKey
#' operation.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param Message &#91;required&#93; Specifies the message or message digest to sign. Messages can be 0-4096
#' bytes. To sign a larger message, provide the message digest.
#' 
#' If you provide a message, AWS KMS generates a hash digest of the message
#' and then signs it.
#' @param MessageType Tells AWS KMS whether the value of the `Message` parameter is a message
#' or message digest. The default value, RAW, indicates a message. To
#' indicate a message digest, enter `DIGEST`.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#' @param SigningAlgorithm &#91;required&#93; Specifies the signing algorithm to use when signing the message.
#' 
#' Choose an algorithm that is compatible with the type and size of the
#' specified asymmetric CMK.
#'
#' @section Request syntax:
#' ```
#' svc$sign(
#'   KeyId = "string",
#'   Message = raw,
#'   MessageType = "RAW"|"DIGEST",
#'   GrantTokens = list(
#'     "string"
#'   ),
#'   SigningAlgorithm = "RSASSA_PSS_SHA_256"|"RSASSA_PSS_SHA_384"|"RSASSA_PSS_SHA_512"|"RSASSA_PKCS1_V1_5_SHA_256"|"RSASSA_PKCS1_V1_5_SHA_384"|"RSASSA_PKCS1_V1_5_SHA_512"|"ECDSA_SHA_256"|"ECDSA_SHA_384"|"ECDSA_SHA_512"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_sign
kms_sign <- function(KeyId, Message, MessageType = NULL, GrantTokens = NULL, SigningAlgorithm) {
  op <- new_operation(
    name = "Sign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$sign_input(KeyId = KeyId, Message = Message, MessageType = MessageType, GrantTokens = GrantTokens, SigningAlgorithm = SigningAlgorithm)
  output <- .kms$sign_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$sign <- kms_sign

#' Adds or edits tags for a customer master key (CMK)
#'
#' Adds or edits tags for a customer master key (CMK). You cannot perform
#' this operation on a CMK in a different AWS account.
#' 
#' Each tag consists of a tag key and a tag value. Tag keys and tag values
#' are both required, but tag values can be empty (null) strings.
#' 
#' You can only use a tag key once for each CMK. If you use the tag key
#' again, AWS KMS replaces the current tag value with the specified value.
#' 
#' For information about the rules that apply to tag keys and tag values,
#' see [User-Defined Tag
#' Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
#' in the *AWS Billing and Cost Management User Guide*.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_tag_resource(KeyId, Tags)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the CMK you are tagging.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Tags &#91;required&#93; One or more tags. Each tag consists of a tag key and a tag value.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   KeyId = "string",
#'   Tags = list(
#'     list(
#'       TagKey = "string",
#'       TagValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example tags a CMK.
#' svc$tag_resource(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Tags = list(
#'     list(
#'       TagKey = "Purpose",
#'       TagValue = "Test"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_tag_resource
kms_tag_resource <- function(KeyId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$tag_resource_input(KeyId = KeyId, Tags = Tags)
  output <- .kms$tag_resource_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$tag_resource <- kms_tag_resource

#' Removes the specified tags from the specified customer master key (CMK)
#'
#' Removes the specified tags from the specified customer master key (CMK).
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' To remove a tag, specify the tag key. To change the tag value of an
#' existing tag key, use TagResource.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_untag_resource(KeyId, TagKeys)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the CMK from which you are removing tags.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param TagKeys &#91;required&#93; One or more tag keys. Specify only the tag keys, not the tag values.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   KeyId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example removes tags from a CMK.
#' svc$untag_resource(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   TagKeys = list(
#'     "Purpose",
#'     "CostCenter"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_untag_resource
kms_untag_resource <- function(KeyId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$untag_resource_input(KeyId = KeyId, TagKeys = TagKeys)
  output <- .kms$untag_resource_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$untag_resource <- kms_untag_resource

#' Associates an existing AWS KMS alias with a different customer master
#' key (CMK)
#'
#' Associates an existing AWS KMS alias with a different customer master
#' key (CMK). Each alias is associated with only one CMK at a time,
#' although a CMK can have multiple aliases. The alias and the CMK must be
#' in the same AWS account and region. You cannot perform this operation on
#' an alias in a different AWS account.
#' 
#' The current and new CMK must be the same type (both symmetric or both
#' asymmetric), and they must have the same key usage (`ENCRYPT_DECRYPT` or
#' `SIGN_VERIFY`). This restriction prevents errors in code that uses
#' aliases. If you must assign an alias to a different type of CMK, use
#' DeleteAlias to delete the old alias and CreateAlias to create a new
#' alias.
#' 
#' You cannot use `UpdateAlias` to change an alias name. To change an alias
#' name, use DeleteAlias to delete the old alias and CreateAlias to create
#' a new alias.
#' 
#' Because an alias is not a property of a CMK, you can create, update, and
#' delete the aliases of a CMK without affecting the CMK. Also, aliases do
#' not appear in the response from the DescribeKey operation. To get the
#' aliases of all CMKs in the account, use the ListAliases operation.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_update_alias(AliasName, TargetKeyId)
#'
#' @param AliasName &#91;required&#93; Identifies the alias that is changing its CMK. This value must begin
#' with `alias/` followed by the alias name, such as `alias/ExampleAlias`.
#' You cannot use UpdateAlias to change the alias name.
#' @param TargetKeyId &#91;required&#93; Identifies the CMK to associate with the alias. When the update
#' operation completes, the alias will point to this CMK.
#' 
#' The CMK must be in the same AWS account and Region as the alias. Also,
#' the new target CMK must be the same type as the current target CMK (both
#' symmetric or both asymmetric) and they must have the same key usage.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' 
#' To verify that the alias is mapped to the correct CMK, use ListAliases.
#'
#' @section Request syntax:
#' ```
#' svc$update_alias(
#'   AliasName = "string",
#'   TargetKeyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example updates the specified alias to refer to the
#' # specified customer master key (CMK).
#' svc$update_alias(
#'   AliasName = "alias/ExampleAlias",
#'   TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_update_alias
kms_update_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$update_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_alias <- kms_update_alias

#' Changes the properties of a custom key store
#'
#' Changes the properties of a custom key store. Use the `CustomKeyStoreId`
#' parameter to identify the custom key store you want to edit. Use the
#' remaining parameters to change the properties of the custom key store.
#' 
#' You can only update a custom key store that is disconnected. To
#' disconnect the custom key store, use DisconnectCustomKeyStore. To
#' reconnect the custom key store after the update completes, use
#' ConnectCustomKeyStore. To find the connection state of a custom key
#' store, use the DescribeCustomKeyStores operation.
#' 
#' Use the parameters of `UpdateCustomKeyStore` to edit your keystore
#' settings.
#' 
#' -   Use the **NewCustomKeyStoreName** parameter to change the friendly
#'     name of the custom key store to the value that you specify.
#' 
#' -   Use the **KeyStorePassword** parameter tell AWS KMS the current
#'     password of the [`kmsuser` crypto user
#'     (CU)](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#'     in the associated AWS CloudHSM cluster. You can use this parameter
#'     to [fix connection
#'     failures](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-password)
#'     that occur when AWS KMS cannot log into the associated cluster
#'     because the `kmsuser` password has changed. This value does not
#'     change the password in the AWS CloudHSM cluster.
#' 
#' -   Use the **CloudHsmClusterId** parameter to associate the custom key
#'     store with a different, but related, AWS CloudHSM cluster. You can
#'     use this parameter to repair a custom key store if its AWS CloudHSM
#'     cluster becomes corrupted or is deleted, or when you need to create
#'     or restore a cluster from a backup.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_update_custom_key_store(CustomKeyStoreId, NewCustomKeyStoreName,
#'   KeyStorePassword, CloudHsmClusterId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Identifies the custom key store that you want to update. Enter the ID of
#' the custom key store. To find the ID of a custom key store, use the
#' DescribeCustomKeyStores operation.
#' @param NewCustomKeyStoreName Changes the friendly name of the custom key store to the value that you
#' specify. The custom key store name must be unique in the AWS account.
#' @param KeyStorePassword Enter the current password of the `kmsuser` crypto user (CU) in the AWS
#' CloudHSM cluster that is associated with the custom key store.
#' 
#' This parameter tells AWS KMS the current password of the `kmsuser`
#' crypto user (CU). It does not set or change the password of any users in
#' the AWS CloudHSM cluster.
#' @param CloudHsmClusterId Associates the custom key store with a related AWS CloudHSM cluster.
#' 
#' Enter the cluster ID of the cluster that you used to create the custom
#' key store or a cluster that shares a backup history and has the same
#' cluster certificate as the original cluster. You cannot use this
#' parameter to associate a custom key store with an unrelated cluster. In
#' addition, the replacement cluster must [fulfill the
#' requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
#' for a cluster associated with a custom key store. To view the cluster
#' certificate of a cluster, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$update_custom_key_store(
#'   CustomKeyStoreId = "string",
#'   NewCustomKeyStoreName = "string",
#'   KeyStorePassword = "string",
#'   CloudHsmClusterId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_update_custom_key_store
kms_update_custom_key_store <- function(CustomKeyStoreId, NewCustomKeyStoreName = NULL, KeyStorePassword = NULL, CloudHsmClusterId = NULL) {
  op <- new_operation(
    name = "UpdateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId, NewCustomKeyStoreName = NewCustomKeyStoreName, KeyStorePassword = KeyStorePassword, CloudHsmClusterId = CloudHsmClusterId)
  output <- .kms$update_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_custom_key_store <- kms_update_custom_key_store

#' Updates the description of a customer master key (CMK)
#'
#' Updates the description of a customer master key (CMK). To see the
#' description of a CMK, use DescribeKey.
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_update_key_description(KeyId, Description)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Description &#91;required&#93; New description for the CMK.
#'
#' @section Request syntax:
#' ```
#' svc$update_key_description(
#'   KeyId = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example updates the description of the specified CMK.
#' svc$update_key_description(
#'   Description = "Example description that indicates the intended use of this CMK.",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname kms_update_key_description
kms_update_key_description <- function(KeyId, Description) {
  op <- new_operation(
    name = "UpdateKeyDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_key_description_input(KeyId = KeyId, Description = Description)
  output <- .kms$update_key_description_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_key_description <- kms_update_key_description

#' Verifies a digital signature that was generated by the Sign operation
#'
#' Verifies a digital signature that was generated by the Sign operation.
#' 
#' Verification confirms that an authorized user signed the message with
#' the specified CMK and signing algorithm, and the message hasn\'t changed
#' since it was signed. If the signature is verified, the value of the
#' `SignatureValid` field in the response is `True`. If the signature
#' verification fails, the `Verify` operation fails with an
#' `KMSInvalidSignatureException` exception.
#' 
#' A digital signature is generated by using the private key in an
#' asymmetric CMK. The signature is verified by using the public key in the
#' same asymmetric CMK. For information about symmetric and asymmetric
#' CMKs, see [Using Symmetric and Asymmetric
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' To verify a digital signature, you can use the `Verify` operation.
#' Specify the same asymmetric CMK, message, and signing algorithm that
#' were used to produce the signature.
#' 
#' You can also verify the digital signature by using the public key of the
#' CMK outside of AWS KMS. Use the GetPublicKey operation to download the
#' public key in the asymmetric CMK and then use the public key to verify
#' the signature outside of AWS KMS. The advantage of using the `Verify`
#' operation is that it is performed within AWS KMS. As a result, it\'s
#' easy to call, the operation is performed within the FIPS boundary, it is
#' logged in AWS CloudTrail, and you can use key policy and IAM policy to
#' determine who is authorized to use the CMK to verify signatures.
#' 
#' The CMK that you use for this operation must be in a compatible key
#' state. For details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_verify(KeyId, Message, MessageType, Signature, SigningAlgorithm,
#'   GrantTokens)
#'
#' @param KeyId &#91;required&#93; Identifies the asymmetric CMK that will be used to verify the signature.
#' This must be the same CMK that was used to generate the signature. If
#' you specify a different CMK, the signature verification fails.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param Message &#91;required&#93; Specifies the message that was signed. You can submit a raw message of
#' up to 4096 bytes, or a hash digest of the message. If you submit a
#' digest, use the `MessageType` parameter with a value of `DIGEST`.
#' 
#' If the message specified here is different from the message that was
#' signed, the signature verification fails. A message and its hash digest
#' are considered to be the same message.
#' @param MessageType Tells AWS KMS whether the value of the `Message` parameter is a message
#' or message digest. The default value, RAW, indicates a message. To
#' indicate a message digest, enter `DIGEST`.
#' 
#' Use the `DIGEST` value only when the value of the `Message` parameter is
#' a message digest. If you use the `DIGEST` value with a raw message, the
#' security of the verification operation can be compromised.
#' @param Signature &#91;required&#93; The signature that the `Sign` operation generated.
#' @param SigningAlgorithm &#91;required&#93; The signing algorithm that was used to sign the message. If you submit a
#' different algorithm, the signature verification fails.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$verify(
#'   KeyId = "string",
#'   Message = raw,
#'   MessageType = "RAW"|"DIGEST",
#'   Signature = raw,
#'   SigningAlgorithm = "RSASSA_PSS_SHA_256"|"RSASSA_PSS_SHA_384"|"RSASSA_PSS_SHA_512"|"RSASSA_PKCS1_V1_5_SHA_256"|"RSASSA_PKCS1_V1_5_SHA_384"|"RSASSA_PKCS1_V1_5_SHA_512"|"ECDSA_SHA_256"|"ECDSA_SHA_384"|"ECDSA_SHA_512",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_verify
kms_verify <- function(KeyId, Message, MessageType = NULL, Signature, SigningAlgorithm, GrantTokens = NULL) {
  op <- new_operation(
    name = "Verify",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$verify_input(KeyId = KeyId, Message = Message, MessageType = MessageType, Signature = Signature, SigningAlgorithm = SigningAlgorithm, GrantTokens = GrantTokens)
  output <- .kms$verify_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$verify <- kms_verify
