% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_identity_provider}
\alias{cognitoidentityprovider_create_identity_provider}
\title{Creates an IdP for a user pool}
\usage{
cognitoidentityprovider_create_identity_provider(
  UserPoolId,
  ProviderName,
  ProviderType,
  ProviderDetails,
  AttributeMapping = NULL,
  IdpIdentifiers = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ProviderName}{[required] The IdP name.}

\item{ProviderType}{[required] The IdP type.}

\item{ProviderDetails}{[required] The IdP details. The following list describes the provider detail keys
for each IdP type.
\itemize{
\item For Google and Login with Amazon:
\itemize{
\item client_id
\item client_secret
\item authorize_scopes
}
\item For Facebook:
\itemize{
\item client_id
\item client_secret
\item authorize_scopes
\item api_version
}
\item For Sign in with Apple:
\itemize{
\item client_id
\item team_id
\item key_id
\item private_key
\item authorize_scopes
}
\item For OpenID Connect (OIDC) providers:
\itemize{
\item client_id
\item client_secret
\item attributes_request_method
\item oidc_issuer
\item authorize_scopes
\item The following keys are only present if Amazon Cognito didn't
discover them at the \code{oidc_issuer} URL.
\itemize{
\item authorize_url
\item token_url
\item attributes_url
\item jwks_uri
}
\item Amazon Cognito sets the value of the following keys
automatically. They are read-only.
\itemize{
\item attributes_url_add_attributes
}
}
\item For SAML providers:
\itemize{
\item MetadataFile or MetadataURL
\item IDPSignout \emph{optional}
}
}}

\item{AttributeMapping}{A mapping of IdP attributes to standard and custom user pool attributes.}

\item{IdpIdentifiers}{A list of IdP identifiers.}
}
\description{
Creates an IdP for a user pool.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/create_identity_provider.html} for full documentation.
}
\keyword{internal}
