% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_trust}
\alias{directoryservice_create_trust}
\title{Directory Service for Microsoft Active Directory allows you to configure
trust relationships}
\usage{
directoryservice_create_trust(
  DirectoryId,
  RemoteDomainName,
  TrustPassword,
  TrustDirection,
  TrustType = NULL,
  ConditionalForwarderIpAddrs = NULL,
  SelectiveAuth = NULL
)
}
\arguments{
\item{DirectoryId}{[required] The Directory ID of the Managed Microsoft AD directory for which to
establish the trust relationship.}

\item{RemoteDomainName}{[required] The Fully Qualified Domain Name (FQDN) of the external domain for which
to create the trust relationship.}

\item{TrustPassword}{[required] The trust password. The must be the same password that was used when
creating the trust relationship on the external domain.}

\item{TrustDirection}{[required] The direction of the trust relationship.}

\item{TrustType}{The trust relationship type. \code{Forest} is the default.}

\item{ConditionalForwarderIpAddrs}{The IP addresses of the remote DNS server associated with
RemoteDomainName.}

\item{SelectiveAuth}{Optional parameter to enable selective authentication for the trust.}
}
\description{
Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft Active Directory. This would allow you to provide users and groups access to resources in either domain, with a single set of credentials.

See \url{https://paws-r.github.io/docs/directoryservice/create_trust.html} for full documentation.
}
\keyword{internal}
