% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_create_web_acl}
\alias{wafv2_create_web_acl}
\title{Creates a WebACL per the specifications provided}
\usage{
wafv2_create_web_acl(
  Name,
  Scope,
  DefaultAction,
  Description = NULL,
  Rules = NULL,
  VisibilityConfig,
  Tags = NULL,
  CustomResponseBodies = NULL,
  CaptchaConfig = NULL
)
}
\arguments{
\item{Name}{[required] The name of the web ACL. You cannot change the name of a web ACL after
you create it.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
or an Amazon Cognito user pool.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{DefaultAction}{[required] The action to perform if none of the \code{Rules} contained in the \code{WebACL}
match.}

\item{Description}{A description of the web ACL that helps with identification.}

\item{Rules}{The Rule statements used to identify the web requests that you want to
allow, block, or count. Each rule includes one top-level statement that
WAF uses to identify matching web requests, and parameters that govern
how WAF handles them.}

\item{VisibilityConfig}{[required] Defines and enables Amazon CloudWatch metrics and web request sample
collection.}

\item{Tags}{An array of key:value pairs to associate with the resource.}

\item{CustomResponseBodies}{A map of custom response keys and content bodies. When you create a rule
with a block action, you can send a custom response to the web request.
You define these for the web ACL, and then use them in the rules and
default actions that you define in the web ACL.

For information about customizing web requests and responses, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html}{Customizing web requests and responses in WAF}
in the \href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{WAF Developer Guide}.

For information about the limits on count and size for custom request
and response settings, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/limits.html}{WAF quotas}
in the \href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{WAF Developer Guide}.}

\item{CaptchaConfig}{Specifies how WAF should handle \code{CAPTCHA} evaluations for rules that
don't have their own \code{CaptchaConfig} settings. If you don't specify
this, WAF uses its default settings for \code{CaptchaConfig}.}
}
\description{
Creates a WebACL per the specifications provided.

See \url{https://paws-r.github.io/docs/wafv2/create_web_acl.html} for full documentation.
}
\keyword{internal}
