% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_verify_mac}
\alias{kms_verify_mac}
\title{Verifies the hash-based message authentication code (HMAC) for a
specified message, HMAC KMS key, and MAC algorithm}
\usage{
kms_verify_mac(Message, KeyId, MacAlgorithm, Mac, GrantTokens = NULL)
}
\arguments{
\item{Message}{[required] The message that will be used in the verification. Enter the same
message that was used to generate the HMAC.

\code{\link[=kms_generate_mac]{generate_mac}} and \code{\link[=kms_verify_mac]{verify_mac}} do
not provide special handling for message digests. If you generated an
HMAC for a hash digest of a message, you must verify the HMAC for the
same hash digest.}

\item{KeyId}{[required] The KMS key that will be used in the verification.

Enter a key ID of the KMS key that was used to generate the HMAC. If you
identify a different KMS key, the \code{\link[=kms_verify_mac]{verify_mac}}
operation fails.}

\item{MacAlgorithm}{[required] The MAC algorithm that will be used in the verification. Enter the same
MAC algorithm that was used to compute the HMAC. This algorithm must be
supported by the HMAC KMS key identified by the \code{KeyId} parameter.}

\item{Mac}{[required] The HMAC to verify. Enter the HMAC that was generated by the
\code{\link[=kms_generate_mac]{generate_mac}} operation when you specified the same
message, HMAC KMS key, and MAC algorithm as the values specified in this
request.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Verifies the hash-based message authentication code (HMAC) for a specified message, HMAC KMS key, and MAC algorithm. To verify the HMAC, \code{\link[=kms_verify_mac]{verify_mac}} computes an HMAC using the message, HMAC KMS key, and MAC algorithm that you specify, and compares the computed HMAC to the HMAC that you specify. If the HMACs are identical, the verification succeeds; otherwise, it fails. Verification indicates that the message hasn't changed since the HMAC was calculated, and the specified key was used to generate and verify the HMAC.

See \url{https://www.paws-r-sdk.com/docs/kms_verify_mac/} for full documentation.
}
\keyword{internal}
