% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_saml_provider}
\alias{iam_create_saml_provider}
\title{Creates an IAM resource that describes an identity provider (IdP) that
supports SAML 2}
\usage{
iam_create_saml_provider(SAMLMetadataDocument, Name, Tags = NULL)
}
\arguments{
\item{SAMLMetadataDocument}{[required] An XML document generated by an identity provider (IdP) that supports
SAML 2.0. The document includes the issuer's name, expiration
information, and keys that can be used to validate the SAML
authentication response (assertions) that are received from the IdP. You
must generate the metadata document using the identity management
software that is used as your organization's IdP.

For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based federation}
in the \emph{IAM User Guide}}

\item{Name}{[required] The name of the provider to create.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{A list of tags that you want to attach to the new IAM SAML provider.
Each tag consists of a key name and an associated value. For more
information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.

See \url{https://www.paws-r-sdk.com/docs/iam_create_saml_provider/} for full documentation.
}
\keyword{internal}
