% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_add_role_to_instance_profile}
\alias{iam_add_role_to_instance_profile}
\title{Adds the specified IAM role to the specified instance profile}
\usage{
iam_add_role_to_instance_profile(InstanceProfileName, RoleName)
}
\arguments{
\item{InstanceProfileName}{[required] The name of the instance profile to update.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{RoleName}{[required] The name of the role to add.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}
}
\description{
Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this quota cannot be increased. You can remove the existing role and then add a different role to an instance profile. You must then wait for the change to appear across all of Amazon Web Services because of \href{https://en.wikipedia.org/wiki/Eventual_consistency}{eventual consistency}. To force the change, you must \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html}{disassociate the instance profile} and then \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html}{associate the instance profile}, or you can stop your instance and then restart it.

See \url{https://www.paws-r-sdk.com/docs/iam_add_role_to_instance_profile/} for full documentation.
}
\keyword{internal}
