% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securitylake_operations.R
\name{securitylake_update_subscriber}
\alias{securitylake_update_subscriber}
\title{Updates an existing subscription for the given Amazon Security Lake
account ID}
\usage{
securitylake_update_subscriber(
  sources = NULL,
  subscriberDescription = NULL,
  subscriberId,
  subscriberIdentity = NULL,
  subscriberName = NULL
)
}
\arguments{
\item{sources}{The supported Amazon Web Services services from which logs and events
are collected. For the list of supported Amazon Web Services services,
see the \href{https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html}{Amazon Security Lake User Guide}.}

\item{subscriberDescription}{The description of the Security Lake account subscriber.}

\item{subscriberId}{[required] A value created by Security Lake that uniquely identifies your
subscription.}

\item{subscriberIdentity}{The Amazon Web Services identity used to access your data.}

\item{subscriberName}{The name of the Security Lake account subscriber.}
}
\description{
Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by changing the sources that the subscriber consumes data from.

See \url{https://www.paws-r-sdk.com/docs/securitylake_update_subscriber/} for full documentation.
}
\keyword{internal}
