% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_complete_multipart_upload}
\alias{s3_complete_multipart_upload}
\title{Completes a multipart upload by assembling previously uploaded parts}
\usage{
s3_complete_multipart_upload(Bucket, Key, MultipartUpload, UploadId,
  RequestPayer)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{MultipartUpload}{}

\item{UploadId}{[required]}

\item{RequestPayer}{}
}
\description{
Completes a multipart upload by assembling previously uploaded parts.
}
\section{Request syntax}{
\preformatted{svc$complete_multipart_upload(
  Bucket = "string",
  Key = "string",
  MultipartUpload = list(
    Parts = list(
      list(
        ETag = "string",
        PartNumber = 123
      )
    )
  ),
  UploadId = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example completes a multipart upload.
\donttest{svc$complete_multipart_upload(
  Bucket = "examplebucket",
  Key = "bigobject",
  MultipartUpload = list(
    Parts = list(
      list(
        ETag = "\\"d8c2eafd90c266e19ab9dcacc479f8af\\"",
        PartNumber = "1"
      ),
      list(
        ETag = "\\"d8c2eafd90c266e19ab9dcacc479f8af\\"",
        PartNumber = "2"
      )
    )
  ),
  UploadId = "7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CE..."
)}

}
\keyword{internal}
