% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_tagging}
\alias{s3_put_object_tagging}
\title{Sets the supplied tag-set to an object that already exists in a bucket}
\usage{
s3_put_object_tagging(Bucket, Key, VersionId, ContentMD5, Tagging)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{VersionId}{}

\item{ContentMD5}{}

\item{Tagging}{[required]}
}
\description{
Sets the supplied tag-set to an object that already exists in a bucket
}
\section{Request syntax}{
\preformatted{svc$put_object_tagging(
  Bucket = "string",
  Key = "string",
  VersionId = "string",
  ContentMD5 = "string",
  Tagging = list(
    TagSet = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}

\examples{
# The following example adds tags to an existing object.
\donttest{svc$put_object_tagging(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  Tagging = list(
    TagSet = list(
      list(
        Key = "Key3",
        Value = "Value3"
      ),
      list(
        Key = "Key4",
        Value = "Value4"
      )
    )
  )
)}

}
\keyword{internal}
