% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_create_nfs_file_share}
\alias{storagegateway_create_nfs_file_share}
\title{Creates a Network File System (NFS) file share on an existing file
gateway}
\usage{
storagegateway_create_nfs_file_share(ClientToken, NFSFileShareDefaults,
  GatewayARN, KMSEncrypted, KMSKey, Role, LocationARN,
  DefaultStorageClass, ObjectACL, ClientList, Squash, ReadOnly,
  GuessMIMETypeEnabled, RequesterPays, Tags)
}
\arguments{
\item{ClientToken}{[required] A unique string value that you supply that is used by file gateway to
ensure idempotent file share creation.}

\item{NFSFileShareDefaults}{File share default values. Optional.}

\item{GatewayARN}{[required] The Amazon Resource Name (ARN) of the file gateway on which you want to
create a file share.}

\item{KMSEncrypted}{True to use Amazon S3 server side encryption with your own AWS KMS key,
or false to use a key managed by Amazon S3. Optional.}

\item{KMSKey}{The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server
side encryption. This value can only be set when KMSEncrypted is true.
Optional.}

\item{Role}{[required] The ARN of the AWS Identity and Access Management (IAM) role that a file
gateway assumes when it accesses the underlying storage.}

\item{LocationARN}{[required] The ARN of the backed storage used for storing file data.}

\item{DefaultStorageClass}{The default storage class for objects put into an Amazon S3 bucket by
the file gateway. Possible values are \code{S3_STANDARD}, \code{S3_STANDARD_IA},
or \code{S3_ONEZONE_IA}. If this field is not populated, the default value
\code{S3_STANDARD} is used. Optional.}

\item{ObjectACL}{A value that sets the access control list permission for objects in the
S3 bucket that a file gateway puts objects into. The default value is
"private".}

\item{ClientList}{The list of clients that are allowed to access the file gateway. The
list must contain either valid IP addresses or valid CIDR blocks.}

\item{Squash}{A value that maps a user to anonymous user. Valid options are the
following:
\itemize{
\item \code{RootSquash} - Only root is mapped to anonymous user.
\item \code{NoSquash} - No one is mapped to anonymous user
\item \code{AllSquash} - Everyone is mapped to anonymous user.
}}

\item{ReadOnly}{A value that sets the write status of a file share. This value is true
if the write status is read-only, and otherwise false.}

\item{GuessMIMETypeEnabled}{A value that enables guessing of the MIME type for uploaded objects
based on file extensions. Set this value to true to enable MIME type
guessing, and otherwise to false. The default value is true.}

\item{RequesterPays}{A value that sets the access control list permission for objects in the
Amazon S3 bucket that a file gateway puts objects into. The default
value is \code{private}.}

\item{Tags}{A list of up to 10 tags that can be assigned to the NFS file share. Each
tag is a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . \_ : / @. The maximum length of a tag's key is 128 characters, and
the maximum length for a tag's value is 256.}
}
\description{
Creates a Network File System (NFS) file share on an existing file
gateway. In Storage Gateway, a file share is a file system mount point
backed by Amazon S3 cloud storage. Storage Gateway exposes file shares
using a NFS interface. This operation is only supported for file
gateways.
}
\details{
File gateway requires AWS Security Token Service (AWS STS) to be
activated to enable you create a file share. Make sure AWS STS is
activated in the region you are creating your file gateway in. If AWS
STS is not activated in the region, activate it. For information about
how to activate AWS STS, see Activating and Deactivating AWS STS in an
AWS Region in the AWS Identity and Access Management User Guide.

File gateway does not support creating hard or symbolic links on a file
share.
}
\section{Request syntax}{
\preformatted{svc$create_nfs_file_share(
  ClientToken = "string",
  NFSFileShareDefaults = list(
    FileMode = "string",
    DirectoryMode = "string",
    GroupId = 123,
    OwnerId = 123
  ),
  GatewayARN = "string",
  KMSEncrypted = TRUE|FALSE,
  KMSKey = "string",
  Role = "string",
  LocationARN = "string",
  DefaultStorageClass = "string",
  ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
  ClientList = list(
    "string"
  ),
  Squash = "string",
  ReadOnly = TRUE|FALSE,
  GuessMIMETypeEnabled = TRUE|FALSE,
  RequesterPays = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
