% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_bandwidth_rate_limit_schedule}
\alias{storagegateway_update_bandwidth_rate_limit_schedule}
\title{Updates the bandwidth rate limit schedule for a specified gateway}
\usage{
storagegateway_update_bandwidth_rate_limit_schedule(GatewayARN,
  BandwidthRateLimitIntervals)
}
\arguments{
\item{GatewayARN}{[required]}

\item{BandwidthRateLimitIntervals}{[required] An array containing bandwidth rate limit schedule intervals for a
gateway. When no bandwidth rate limit intervals have been scheduled, the
array is empty.}
}
\description{
Updates the bandwidth rate limit schedule for a specified gateway. By
default, gateways do not have bandwidth rate limit schedules, which
means no bandwidth rate limiting is in effect. Use this to initiate or
update a gateway's bandwidth rate limit schedule. This operation is
supported in the volume and tape gateway types.
}
\section{Request syntax}{
\preformatted{svc$update_bandwidth_rate_limit_schedule(
  GatewayARN = "string",
  BandwidthRateLimitIntervals = list(
    list(
      StartHourOfDay = 123,
      StartMinuteOfHour = 123,
      EndHourOfDay = 123,
      EndMinuteOfHour = 123,
      DaysOfWeek = list(
        123
      ),
      AverageUploadRateLimitInBitsPerSec = 123,
      AverageDownloadRateLimitInBitsPerSec = 123
    )
  )
)
}
}

\keyword{internal}
