% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_describe_mount_targets}
\alias{efs_describe_mount_targets}
\title{Returns the descriptions of all the current mount targets, or a specific
mount target, for a file system}
\usage{
efs_describe_mount_targets(MaxItems, Marker, FileSystemId,
  MountTargetId, AccessPointId)
}
\arguments{
\item{MaxItems}{(Optional) Maximum number of mount targets to return in the response.
Currently, this number is automatically set to 10, and other values are
ignored. The response is paginated at 100 per page if you have more than
100 mount targets.}

\item{Marker}{(Optional) Opaque pagination token returned from a previous
\code{\link[=efs_describe_mount_targets]{describe_mount_targets}} operation
(String). If present, it specifies to continue the list from where the
previous returning call left off.}

\item{FileSystemId}{(Optional) ID of the file system whose mount targets you want to list
(String). It must be included in your request if an \code{AccessPointId} or
\code{MountTargetId} is not included. Accepts either a file system ID or ARN
as input.}

\item{MountTargetId}{(Optional) ID of the mount target that you want to have described
(String). It must be included in your request if \code{FileSystemId} is not
included. Accepts either a mount target ID or ARN as input.}

\item{AccessPointId}{(Optional) The ID of the access point whose mount targets that you want
to list. It must be included in your request if a \code{FileSystemId} or
\code{MountTargetId} is not included in your request. Accepts either an
access point ID or ARN as input.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  MountTargets = list(
    list(
      OwnerId = "string",
      MountTargetId = "string",
      FileSystemId = "string",
      SubnetId = "string",
      LifeCycleState = "creating"|"available"|"updating"|"deleting"|"deleted",
      IpAddress = "string",
      NetworkInterfaceId = "string",
      AvailabilityZoneId = "string",
      AvailabilityZoneName = "string",
      VpcId = "string"
    )
  ),
  NextMarker = "string"
)
}
}
\description{
Returns the descriptions of all the current mount targets, or a specific
mount target, for a file system. When requesting all of the current
mount targets, the order of mount targets returned in the response is
unspecified.

This operation requires permissions for the
\code{elasticfilesystem:DescribeMountTargets} action, on either the file
system ID that you specify in \code{FileSystemId}, or on the file system of
the mount target that you specify in \code{MountTargetId}.
}
\section{Request syntax}{
\preformatted{svc$describe_mount_targets(
  MaxItems = 123,
  Marker = "string",
  FileSystemId = "string",
  MountTargetId = "string",
  AccessPointId = "string"
)
}
}

\examples{
\dontrun{
# This operation describes all of a file system's mount targets.
svc$describe_mount_targets(
  FileSystemId = "fs-01234567"
)
}

}
\keyword{internal}
