% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_backup_job}
\alias{backup_start_backup_job}
\title{Starts an on-demand backup job for the specified resource}
\usage{
backup_start_backup_job(BackupVaultName, ResourceArn, IamRoleArn,
  IdempotencyToken, StartWindowMinutes, CompleteWindowMinutes, Lifecycle,
  RecoveryPointTags, BackupOptions)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{ResourceArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a resource. The
format of the ARN depends on the resource type.}

\item{IamRoleArn}{[required] Specifies the IAM role ARN used to create the target recovery point; for
example, \verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer chosen string that can be used to distinguish between calls
to \code{\link[=backup_start_backup_job]{start_backup_job}}.}

\item{StartWindowMinutes}{A value in minutes after a backup is scheduled before a job will be
canceled if it doesn't start successfully. This value is optional.}

\item{CompleteWindowMinutes}{A value in minutes after a backup job is successfully started before it
must be completed or it will be canceled by AWS Backup. This value is
optional.}

\item{Lifecycle}{The lifecycle defines when a protected resource is transitioned to cold
storage and when it expires. AWS Backup will transition and expire
backups automatically according to the lifecycle that you define.

Backups transitioned to cold storage must be stored in cold storage for
a minimum of 90 days. Therefore, the “expire after days” setting must be
90 days greater than the “transition to cold after days” setting. The
“transition to cold after days” setting cannot be changed after a backup
has been transitioned to cold.}

\item{RecoveryPointTags}{To help organize your resources, you can assign your own metadata to the
resources that you create. Each tag is a key-value pair.}

\item{BackupOptions}{Specifies the backup option for a selected resource. This option is only
available for Windows VSS backup jobs.

Valid values: Set to \code{"WindowsVSS”:“enabled"} to enable WindowsVSS
backup option and create a VSS Windows backup. Set to
“WindowsVSS”:”disabled” to create a regular backup. The WindowsVSS
option is not enabled by default.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupJobId = "string",
  RecoveryPointArn = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Starts an on-demand backup job for the specified resource.
}
\section{Request syntax}{
\preformatted{svc$start_backup_job(
  BackupVaultName = "string",
  ResourceArn = "string",
  IamRoleArn = "string",
  IdempotencyToken = "string",
  StartWindowMinutes = 123,
  CompleteWindowMinutes = 123,
  Lifecycle = list(
    MoveToColdStorageAfterDays = 123,
    DeleteAfterDays = 123
  ),
  RecoveryPointTags = list(
    "string"
  ),
  BackupOptions = list(
    "string"
  )
)
}
}

\keyword{internal}
