% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_accelerate_configuration}
\alias{s3_get_bucket_accelerate_configuration}
\title{This implementation of the GET operation uses the accelerate subresource
to return the Transfer Acceleration state of a bucket, which is either
Enabled or Suspended}
\usage{
s3_get_bucket_accelerate_configuration(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which the accelerate configuration is
retrieved.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "Enabled"|"Suspended"
)
}
}
\description{
This implementation of the GET operation uses the \code{accelerate}
subresource to return the Transfer Acceleration state of a bucket, which
is either \code{Enabled} or \code{Suspended}. Amazon S3 Transfer Acceleration is a
bucket-level feature that enables you to perform faster data transfers
to and from Amazon S3.

To use this operation, you must have permission to perform the
\code{s3:GetAccelerateConfiguration} action. The bucket owner has this
permission by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to your Amazon S3 Resources}
in the \emph{Amazon Simple Storage Service Developer Guide}.

You set the Transfer Acceleration state of an existing bucket to
\code{Enabled} or \code{Suspended} by using the
\code{\link[=s3_put_bucket_accelerate_configuration]{put_bucket_accelerate_configuration}}
operation.

A GET \code{accelerate} request does not return a state value for a bucket
that has no transfer acceleration state. A bucket has no Transfer
Acceleration state if a state has never been set on the bucket.

For more information about transfer acceleration, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/transfer-acceleration.html}{Transfer Acceleration}
in the Amazon Simple Storage Service Developer Guide.

\strong{Related Resources}
\itemize{
\item \code{\link[=s3_put_bucket_accelerate_configuration]{put_bucket_accelerate_configuration}}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_accelerate_configuration(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
