% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_upload_part_copy}
\alias{s3_upload_part_copy}
\title{Uploads a part by copying data from an existing object as data source}
\usage{
s3_upload_part_copy(Bucket, CopySource, CopySourceIfMatch,
  CopySourceIfModifiedSince, CopySourceIfNoneMatch,
  CopySourceIfUnmodifiedSince, CopySourceRange, Key, PartNumber, UploadId,
  SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey,
  CopySourceSSECustomerKeyMD5, RequestPayer)
}
\arguments{
\item{Bucket}{[required]}

\item{CopySource}{[required] The name of the source bucket and key name of the source object,
separated by a slash (/). Must be URL-encoded.}

\item{CopySourceIfMatch}{Copies the object if its entity tag (ETag) matches the specified tag.}

\item{CopySourceIfModifiedSince}{Copies the object if it has been modified since the specified time.}

\item{CopySourceIfNoneMatch}{Copies the object if its entity tag (ETag) is different than the
specified ETag.}

\item{CopySourceIfUnmodifiedSince}{Copies the object if it hasn't been modified since the specified time.}

\item{CopySourceRange}{The range of bytes to copy from the source object. The range value must
use the form bytes=first-last, where the first and last are the
zero-based byte offsets to copy. For example, bytes=0-9 indicates that
you want to copy the first ten bytes of the source. You can copy a range
only if the source object is greater than 5 MB.}

\item{Key}{[required]}

\item{PartNumber}{[required] Part number of part being copied. This is a positive integer between 1
and 10,000.}

\item{UploadId}{[required] Upload ID identifying the multipart upload whose part is being copied.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header. This must be
the same encryption key specified in the initiate multipart upload
request.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{CopySourceSSECustomerAlgorithm}{Specifies the algorithm to use when decrypting the source object (e.g.,
AES256).}

\item{CopySourceSSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use to
decrypt the source object. The encryption key provided in this header
must be one that was used when the source object was created.}

\item{CopySourceSSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{RequestPayer}{}
}
\description{
Uploads a part by copying data from an existing object as data source.
}
\section{Request syntax}{
\preformatted{svc$upload_part_copy(
  Bucket = "string",
  CopySource = "string",
  CopySourceIfMatch = "string",
  CopySourceIfModifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  CopySourceIfNoneMatch = "string",
  CopySourceIfUnmodifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  CopySourceRange = "string",
  Key = "string",
  PartNumber = 123,
  UploadId = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  CopySourceSSECustomerAlgorithm = "string",
  CopySourceSSECustomerKey = raw,
  CopySourceSSECustomerKeyMD5 = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example uploads a part of a multipart upload by copying
# data from an existing object as data source.
\donttest{svc$upload_part_copy(
  Bucket = "examplebucket",
  CopySource = "/bucketname/sourceobjectkey",
  Key = "examplelargeobject",
  PartNumber = "1",
  UploadId = "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP..."
)}

# The following example uploads a part of a multipart upload by copying a
# specified byte range from an existing object as data source.
\donttest{svc$upload_part_copy(
  Bucket = "examplebucket",
  CopySource = "/bucketname/sourceobjectkey",
  CopySourceRange = "bytes=1-100000",
  Key = "examplelargeobject",
  PartNumber = "2",
  UploadId = "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP..."
)}

}
\keyword{internal}
