% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_assign_tape_pool}
\alias{storagegateway_assign_tape_pool}
\title{Assigns a tape to a tape pool for archiving}
\usage{
storagegateway_assign_tape_pool(TapeARN, PoolId)
}
\arguments{
\item{TapeARN}{[required] The unique Amazon Resource Name (ARN) of the virtual tape that you want
to add to the tape pool.}

\item{PoolId}{[required] The ID of the pool that you want to add your tape to for archiving. The
tape in this pool is archived in the S3 storage class that is associated
with the pool. When you use your backup application to eject the tape,
the tape is archived directly into the storage class (Glacier or Deep
Archive) that corresponds to the pool.

Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"}
}
\description{
Assigns a tape to a tape pool for archiving. The tape assigned to a pool
is archived in the S3 storage class that is associated with the pool.
When you use your backup application to eject the tape, the tape is
archived directly into the S3 storage class (Glacier or Deep Archive)
that corresponds to the pool.
}
\details{
Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"
}
\section{Request syntax}{
\preformatted{svc$assign_tape_pool(
  TapeARN = "string",
  PoolId = "string"
)
}
}

\keyword{internal}
