% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_file_system}
\alias{fsx_create_file_system}
\title{Creates a new, empty Amazon FSx file system}
\usage{
fsx_create_file_system(ClientRequestToken, FileSystemType,
  StorageCapacity, SubnetIds, SecurityGroupIds, Tags, KmsKeyId,
  WindowsConfiguration, LustreConfiguration)
}
\arguments{
\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent creation. This string is automatically filled on your
behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
SDK.}

\item{FileSystemType}{[required] The type of Amazon FSx file system to create.}

\item{StorageCapacity}{[required] The storage capacity of the file system being created.

For Windows file systems, valid values are 32 GiB - 65,536 GiB.

For Lustre file systems, valid values are 1,200, 2,400, 3,600, then
continuing in increments of 3600 GiB.}

\item{SubnetIds}{[required] Specifies the IDs of the subnets that the file system will be accessible
from. For Windows \code{MULTI_AZ_1} file system deployment types, provide
exactly two subnet IDs, one for the preferred file server and one for
the standy file server. You specify one of these subnets as the
preferred subnet using the \verb{WindowsConfiguration &gt; PreferredSubnetID}
property.

For Windows \code{SINGLE_AZ_1} file system deployment types and Lustre file
systems, provide exactly one subnet ID. The file server is launched in
that subnet\'s Availability Zone.}

\item{SecurityGroupIds}{A list of IDs specifying the security groups to apply to all network
interfaces created for file system access. This list isn\'t returned in
later requests to describe the file system.}

\item{Tags}{The tags to apply to the file system being created. The key value of the
\code{Name} tag appears in the console as the file system name.}

\item{KmsKeyId}{}

\item{WindowsConfiguration}{The Microsoft Windows configuration for the file system being created.
This value is required if \code{FileSystemType} is set to \code{WINDOWS}.}

\item{LustreConfiguration}{}
}
\description{
Creates a new, empty Amazon FSx file system.
}
\details{
If a file system with the specified client request token exists and the
parameters match, \code{CreateFileSystem} returns the description of the
existing file system. If a file system specified client request token
exists and the parameters don\'t match, this call returns
\code{IncompatibleParameterError}. If a file system with the specified client
request token doesn\'t exist, \code{CreateFileSystem} does the following:
\itemize{
\item Creates a new, empty Amazon FSx file system with an assigned ID, and
an initial lifecycle state of \code{CREATING}.
\item Returns the description of the file system.
}

This operation requires a client request token in the request that
Amazon FSx uses to ensure idempotent creation. This means that calling
the operation multiple times with the same client request token has no
effect. By using the idempotent operation, you can retry a
\code{CreateFileSystem} operation without the risk of creating an extra file
system. This approach can be useful when an initial call fails in a way
that makes it unclear whether a file system was created. Examples are if
a transport level timeout occurred, or your connection was reset. If you
use the same client request token and the initial call created a file
system, the client receives success as long as the parameters are the
same.

The \code{CreateFileSystem} call returns while the file system\'s lifecycle
state is still \code{CREATING}. You can check the file-system creation status
by calling the DescribeFileSystems operation, which returns the file
system state along with other information.
}
\section{Request syntax}{
\preformatted{svc$create_file_system(
  ClientRequestToken = "string",
  FileSystemType = "WINDOWS"|"LUSTRE",
  StorageCapacity = 123,
  SubnetIds = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  WindowsConfiguration = list(
    ActiveDirectoryId = "string",
    SelfManagedActiveDirectoryConfiguration = list(
      DomainName = "string",
      OrganizationalUnitDistinguishedName = "string",
      FileSystemAdministratorsGroup = "string",
      UserName = "string",
      Password = "string",
      DnsIps = list(
        "string"
      )
    ),
    DeploymentType = "MULTI_AZ_1"|"SINGLE_AZ_1",
    PreferredSubnetId = "string",
    ThroughputCapacity = 123,
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    CopyTagsToBackups = TRUE|FALSE
  ),
  LustreConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    ImportPath = "string",
    ExportPath = "string",
    ImportedFileChunkSize = 123
  )
)
}
}

\examples{
\dontrun{
# This operation creates a new file system.
svc$create_file_system(
  ClientRequestToken = "a8ca07e4-61ec-4399-99f4-19853801bcd5",
  FileSystemType = "WINDOWS",
  KmsKeyId = "arn:aws:kms:us-east-1:012345678912:key/0ff3ea8d-130e-4133-877f-93908b6fdbd6",
  SecurityGroupIds = list(
    "sg-edcd9784"
  ),
  StorageCapacity = 300L,
  SubnetIds = list(
    "subnet-1234abcd"
  ),
  Tags = list(
    list(
      Key = "Name",
      Value = "MyFileSystem"
    )
  ),
  WindowsConfiguration = list(
    ActiveDirectoryId = "d-1234abcd12",
    AutomaticBackupRetentionDays = 30L,
    DailyAutomaticBackupStartTime = "05:00",
    ThroughputCapacity = 8L,
    WeeklyMaintenanceStartTime = "1:05:00"
  )
)
}

}
\keyword{internal}
