% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_upload_buffer}
\alias{storagegateway_describe_upload_buffer}
\title{Returns information about the upload buffer of a gateway}
\usage{
storagegateway_describe_upload_buffer(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Returns information about the upload buffer of a gateway. This operation
is supported for the stored volume, cached volume, and tape gateway
types.
}
\details{
The response includes disk IDs that are configured as upload buffer
space, and it includes the amount of upload buffer space allocated and
used.
}
\section{Request syntax}{
\preformatted{svc$describe_upload_buffer(
  GatewayARN = "string"
)
}
}

\examples{
\dontrun{
# Returns information about the upload buffer of a gateway including disk
# IDs and the amount of upload buffer space allocated/used.
svc$describe_upload_buffer(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)

# Returns information about the upload buffer of a gateway including disk
# IDs and the amount of upload buffer space allocated and used.
svc$describe_upload_buffer(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)
}

}
\keyword{internal}
