% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_vtl_devices}
\alias{storagegateway_describe_vtl_devices}
\title{Returns a description of virtual tape library (VTL) devices for the
specified tape gateway}
\usage{
storagegateway_describe_vtl_devices(
  GatewayARN,
  VTLDeviceARNs = NULL,
  Marker = NULL,
  Limit = NULL
)
}
\arguments{
\item{GatewayARN}{[required]}

\item{VTLDeviceARNs}{An array of strings, where each string represents the Amazon Resource
Name (ARN) of a VTL device.

All of the specified VTL devices must be from the same gateway. If no
VTL devices are specified, the result will contain all devices on the
specified gateway.}

\item{Marker}{An opaque string that indicates the position at which to begin
describing the VTL devices.}

\item{Limit}{Specifies that the number of VTL devices described be limited to the
specified number.}
}
\description{
Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.

See \url{https://paws-r.github.io/docs/storagegateway/describe_vtl_devices.html} for full documentation.
}
\keyword{internal}
