% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_data_repository_association}
\alias{fsx_create_data_repository_association}
\title{Creates an Amazon FSx for Lustre data repository association (DRA)}
\usage{
fsx_create_data_repository_association(
  FileSystemId,
  FileSystemPath = NULL,
  DataRepositoryPath,
  BatchImportMetaDataOnCreate = NULL,
  ImportedFileChunkSize = NULL,
  S3 = NULL,
  ClientRequestToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{FileSystemId}{[required]}

\item{FileSystemPath}{A path on the file system that points to a high-level directory (such as
\verb{/ns1/}) or subdirectory (such as \verb{/ns1/subdir/}) that will be mapped
1-1 with \code{DataRepositoryPath}. The leading forward slash in the name is
required. Two data repository associations cannot have overlapping file
system paths. For example, if a data repository is associated with file
system path \verb{/ns1/}, then you cannot link another data repository with
file system path \verb{/ns1/ns2}.

This path specifies where in your file system files will be exported
from or imported to. This file system directory can be linked to only
one Amazon S3 bucket, and no other S3 bucket can be linked to the
directory.

If you specify only a forward slash (\code{/}) as the file system path, you
can link only one data repository to the file system. You can only
specify "/" as the file system path for the first data repository
associated with a file system.}

\item{DataRepositoryPath}{[required] The path to the Amazon S3 data repository that will be linked to the
file system. The path can be an S3 bucket or prefix in the format
\verb{s3://myBucket/myPrefix/}. This path specifies where in the S3 data
repository files will be imported from or exported to.}

\item{BatchImportMetaDataOnCreate}{Set to \code{true} to run an import data repository task to import metadata
from the data repository to the file system after the data repository
association is created. Default is \code{false}.}

\item{ImportedFileChunkSize}{For files imported from a data repository, this value determines the
stripe count and maximum amount of data per file (in MiB) stored on a
single physical disk. The maximum number of disks that a single file can
be striped across is limited by the total number of disks that make up
the file system.

The default chunk size is 1,024 MiB (1 GiB) and can go as high as
512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.}

\item{S3}{The configuration for an Amazon S3 data repository linked to an Amazon
FSx Lustre file system with a data repository association. The
configuration defines which file events (new, changed, or deleted files
or directories) are automatically imported from the linked data
repository to the file system or automatically exported from the file
system to the data repository.}

\item{ClientRequestToken}{}

\item{Tags}{}
}
\description{
Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding \code{scratch_1} deployment type.

See \url{https://www.paws-r-sdk.com/docs/fsx_create_data_repository_association/} for full documentation.
}
\keyword{internal}
