% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_inventory_configuration}
\alias{s3_put_bucket_inventory_configuration}
\title{This implementation of the PUT action adds an inventory configuration
(identified by the inventory ID) to the bucket}
\usage{
s3_put_bucket_inventory_configuration(
  Bucket,
  Id,
  InventoryConfiguration,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket where the inventory configuration will be stored.}

\item{Id}{[required] The ID used to identify the inventory configuration.}

\item{InventoryConfiguration}{[required] Specifies the inventory configuration.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This implementation of the \code{PUT} action adds an inventory configuration (identified by the inventory ID) to the bucket. You can have up to 1,000 inventory configurations per bucket.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_inventory_configuration/} for full documentation.
}
\keyword{internal}
