% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_ownership_controls}
\alias{s3_get_bucket_ownership_controls}
\title{Retrieves OwnershipControls for an Amazon S3 bucket}
\usage{
s3_get_bucket_ownership_controls(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the Amazon S3 bucket whose \code{OwnershipControls} you want to
retrieve.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Retrieves \code{OwnershipControls} for an Amazon S3 bucket. To use this operation, you must have the \code{s3:GetBucketOwnershipControls} permission. For more information about Amazon S3 permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html}{Specifying permissions in a policy}.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_ownership_controls/} for full documentation.
}
\keyword{internal}
