% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_policy}
\alias{s3_get_bucket_policy}
\title{Returns the policy of a specified bucket}
\usage{
s3_get_bucket_policy(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the bucket policy.

To use this API operation against an access point, provide the alias of
the access point in place of the bucket name.

To use this API operation against an Object Lambda access point, provide
the alias of the Object Lambda access point in place of the bucket name.
If the Object Lambda access point alias in a request is not valid, the
error code \code{InvalidAccessPointAliasError} is returned. For more
information about \code{InvalidAccessPointAliasError}, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList}{List of Error Codes}.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the \code{\link[=s3_get_bucket_policy]{get_bucket_policy}} permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_policy/} for full documentation.
}
\keyword{internal}
