% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_restore_jobs}
\alias{backup_list_restore_jobs}
\title{Returns a list of jobs that Backup initiated to restore a saved
resource, including details about the recovery process}
\usage{
backup_list_restore_jobs(
  NextToken = NULL,
  MaxResults = NULL,
  ByAccountId = NULL,
  ByResourceType = NULL,
  ByCreatedBefore = NULL,
  ByCreatedAfter = NULL,
  ByStatus = NULL,
  ByCompleteBefore = NULL,
  ByCompleteAfter = NULL,
  ByRestoreTestingPlanArn = NULL
)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{MaxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByAccountId}{The account ID to list the jobs from. Returns only restore jobs
associated with the specified account ID.}

\item{ByResourceType}{Include this parameter to return only restore jobs for the specified
resources:
\itemize{
\item \code{Aurora} for Amazon Aurora
\item \code{CloudFormation} for CloudFormation
\item \code{DocumentDB} for Amazon DocumentDB (with MongoDB compatibility)
\item \code{DynamoDB} for Amazon DynamoDB
\item \code{EBS} for Amazon Elastic Block Store
\item \code{EC2} for Amazon Elastic Compute Cloud
\item \code{EFS} for Amazon Elastic File System
\item \code{FSx} for Amazon FSx
\item \code{Neptune} for Amazon Neptune
\item \code{Redshift} for Amazon Redshift
\item \code{RDS} for Amazon Relational Database Service
\item \verb{SAP HANA on Amazon EC2} for SAP HANA databases
\item \verb{Storage Gateway} for Storage Gateway
\item \code{S3} for Amazon S3
\item \code{Timestream} for Amazon Timestream
\item \code{VirtualMachine} for virtual machines
}}

\item{ByCreatedBefore}{Returns only restore jobs that were created before the specified date.}

\item{ByCreatedAfter}{Returns only restore jobs that were created after the specified date.}

\item{ByStatus}{Returns only restore jobs associated with the specified job status.}

\item{ByCompleteBefore}{Returns only copy jobs completed before a date expressed in Unix format
and Coordinated Universal Time (UTC).}

\item{ByCompleteAfter}{Returns only copy jobs completed after a date expressed in Unix format
and Coordinated Universal Time (UTC).}

\item{ByRestoreTestingPlanArn}{This returns only restore testing jobs that match the specified resource
Amazon Resource Name (ARN).}
}
\description{
Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.

See \url{https://www.paws-r-sdk.com/docs/backup_list_restore_jobs/} for full documentation.
}
\keyword{internal}
