% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_file_system_aliases}
\alias{fsx_describe_file_system_aliases}
\title{Returns the DNS aliases that are associated with the specified Amazon
FSx for Windows File Server file system}
\usage{
fsx_describe_file_system_aliases(
  ClientRequestToken = NULL,
  FileSystemId,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ClientRequestToken}{}

\item{FileSystemId}{[required] The ID of the file system to return the associated DNS aliases for
(String).}

\item{MaxResults}{Maximum number of DNS aliases to return in the response (integer). This
parameter value must be greater than 0. The number of items that Amazon
FSx returns is the minimum of the \code{MaxResults} parameter specified in
the request and the service's internal maximum number of items per page.}

\item{NextToken}{Opaque pagination token returned from a previous
\code{\link[=fsx_describe_file_system_aliases]{describe_file_system_aliases}}
operation (String). If a token is included in the request, the action
continues the list from where the previous returning call left off.}
}
\description{
Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of AdministrativeAction provided in the \code{\link[=fsx_describe_file_systems]{describe_file_systems}} operation response.

See \url{https://www.paws-r-sdk.com/docs/fsx_describe_file_system_aliases/} for full documentation.
}
\keyword{internal}
