% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_legal_hold}
\alias{backup_create_legal_hold}
\title{This action creates a legal hold on a recovery point (backup)}
\usage{
backup_create_legal_hold(
  Title,
  Description,
  IdempotencyToken = NULL,
  RecoveryPointSelection = NULL,
  Tags = NULL
)
}
\arguments{
\item{Title}{[required] This is the string title of the legal hold.}

\item{Description}{[required] This is the string description of the legal hold.}

\item{IdempotencyToken}{This is a user-chosen string used to distinguish between otherwise
identical calls. Retrying a successful request with the same idempotency
token results in a success message with no action taken.}

\item{RecoveryPointSelection}{This specifies criteria to assign a set of resources, such as resource
types or backup vaults.}

\item{Tags}{Optional tags to include. A tag is a key-value pair you can use to
manage, filter, and search for your resources. Allowed characters
include UTF-8 letters, numbers, spaces, and the following
characters: + - = . _ : /.}
}
\description{
This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.

See \url{https://www.paws-r-sdk.com/docs/backup_create_legal_hold/} for full documentation.
}
\keyword{internal}
