% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_copy_snapshot_and_update_volume}
\alias{fsx_copy_snapshot_and_update_volume}
\title{Updates an existing volume by using a snapshot from another Amazon FSx
for OpenZFS file system}
\usage{
fsx_copy_snapshot_and_update_volume(
  ClientRequestToken = NULL,
  VolumeId,
  SourceSnapshotARN,
  CopyStrategy = NULL,
  Options = NULL
)
}
\arguments{
\item{ClientRequestToken}{}

\item{VolumeId}{[required] Specifies the ID of the volume that you are copying the snapshot to.}

\item{SourceSnapshotARN}{[required]}

\item{CopyStrategy}{Specifies the strategy to use when copying data from a snapshot to the
volume.
\itemize{
\item \code{FULL_COPY} - Copies all data from the snapshot to the volume.
\item \code{INCREMENTAL_COPY} - Copies only the snapshot data that's changed
since the previous replication.
}

\code{CLONE} isn't a valid copy strategy option for the
\code{\link[=fsx_copy_snapshot_and_update_volume]{copy_snapshot_and_update_volume}}
operation.}

\item{Options}{Confirms that you want to delete data on the destination volume that
wasn’t there during the previous snapshot replication.

Your replication will fail if you don’t include an option for a specific
type of data and that data is on your destination. For example, if you
don’t include \code{DELETE_INTERMEDIATE_SNAPSHOTS} and there are intermediate
snapshots on the destination, you can’t copy the snapshot.
\itemize{
\item \code{DELETE_INTERMEDIATE_SNAPSHOTS} - Deletes snapshots on the
destination volume that aren’t on the source volume.
\item \code{DELETE_CLONED_VOLUMES} - Deletes snapshot clones on the destination
volume that aren't on the source volume.
\item \code{DELETE_INTERMEDIATE_DATA} - Overwrites snapshots on the destination
volume that don’t match the source snapshot that you’re copying.
}}
}
\description{
Updates an existing volume by using a snapshot from another Amazon FSx for OpenZFS file system. For more information, see \href{https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/on-demand-replication.html}{on-demand data replication} in the Amazon FSx for OpenZFS User Guide.

See \url{https://www.paws-r-sdk.com/docs/fsx_copy_snapshot_and_update_volume/} for full documentation.
}
\keyword{internal}
