% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_storage_virtual_machine}
\alias{fsx_create_storage_virtual_machine}
\title{Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file
system}
\usage{
fsx_create_storage_virtual_machine(
  ActiveDirectoryConfiguration = NULL,
  ClientRequestToken = NULL,
  FileSystemId,
  Name,
  SvmAdminPassword = NULL,
  Tags = NULL,
  RootVolumeSecurityStyle = NULL
)
}
\arguments{
\item{ActiveDirectoryConfiguration}{Describes the self-managed Microsoft Active Directory to which you want
to join the SVM. Joining an Active Directory provides user
authentication and access control for SMB clients, including Microsoft
Windows and macOS clients accessing the file system.}

\item{ClientRequestToken}{}

\item{FileSystemId}{[required]}

\item{Name}{[required] The name of the SVM.}

\item{SvmAdminPassword}{The password to use when managing the SVM using the NetApp ONTAP CLI or
REST API. If you do not specify a password, you can still use the file
system's \code{fsxadmin} user to manage the SVM.}

\item{Tags}{}

\item{RootVolumeSecurityStyle}{The security style of the root volume of the SVM. Specify one of the
following values:
\itemize{
\item \code{UNIX} if the file system is managed by a UNIX administrator, the
majority of users are NFS clients, and an application accessing the
data uses a UNIX user as the service account.
\item \code{NTFS} if the file system is managed by a Microsoft Windows
administrator, the majority of users are SMB clients, and an
application accessing the data uses a Microsoft Windows user as the
service account.
\item \code{MIXED} This is an advanced setting. For more information, see
\href{https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/}{Volume security style} in the
Amazon FSx for NetApp ONTAP User Guide.
}}
}
\description{
Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.

See \url{https://www.paws-r-sdk.com/docs/fsx_create_storage_virtual_machine/} for full documentation.
}
\keyword{internal}
