% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{dynamodbstreams}
\alias{dynamodbstreams}
\title{Amazon DynamoDB Streams}
\usage{
dynamodbstreams(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon DynamoDB

Amazon DynamoDB Streams provides API actions for accessing streams and
processing stream records. To learn more about application development
with Streams, see \href{http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Streams.html}{Capturing Table Activity with DynamoDB Streams}
in the Amazon DynamoDB Developer Guide.
}
\section{Service syntax}{
\preformatted{svc <- dynamodbstreams(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=dynamodbstreams_describe_stream]{describe_stream} \tab Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table\cr
\link[=dynamodbstreams_get_records]{get_records} \tab Retrieves the stream records from a given shard \cr
\link[=dynamodbstreams_get_shard_iterator]{get_shard_iterator} \tab Returns a shard iterator \cr
\link[=dynamodbstreams_list_streams]{list_streams} \tab Returns an array of stream ARNs associated with the current account and endpoint
}
}

\examples{
\dontrun{
svc <- dynamodbstreams()
# The following example describes a stream with a given stream ARN.
svc$describe_stream(
  StreamArn = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2015-05-20T20:51:1..."
)
}

}
