% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{cloudwatchinternetmonitor}
\alias{cloudwatchinternetmonitor}
\title{Amazon CloudWatch Internet Monitor}
\usage{
cloudwatchinternetmonitor(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon CloudWatch Internet Monitor provides visibility into how internet
issues impact the performance and availability between your applications
hosted on Amazon Web Services and your end users. It can reduce the time
it takes for you to diagnose internet issues from days to minutes.
Internet Monitor uses the connectivity data that Amazon Web Services
captures from its global networking footprint to calculate a baseline of
performance and availability for internet traffic. This is the same data
that Amazon Web Services uses to monitor internet uptime and
availability. With those measurements as a baseline, Internet Monitor
raises awareness for you when there are significant problems for your
end users in the different geographic locations where your application
runs.

Internet Monitor publishes internet measurements to CloudWatch Logs and
CloudWatch Metrics, to easily support using CloudWatch tools with health
information for geographies and networks specific to your application.
Internet Monitor sends health events to Amazon EventBridge so that you
can set up notifications. If an issue is caused by the Amazon Web
Services network, you also automatically receive an Amazon Web Services
Health Dashboard notification with the steps that Amazon Web Services is
taking to mitigate the problem.

To use Internet Monitor, you create a \emph{monitor} and associate your
application's resources with it - VPCs, NLBs, CloudFront distributions,
or WorkSpaces directories - so Internet Monitor can determine where your
application's internet traffic is. Internet Monitor then provides
internet measurements from Amazon Web Services that are specific to the
locations and ASNs (typically, internet service providers or ISPs) that
communicate with your application.

For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html}{Using Amazon CloudWatch Internet Monitor}
in the \emph{Amazon CloudWatch User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- cloudwatchinternetmonitor(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:cloudwatchinternetmonitor_create_monitor]{create_monitor} \tab Creates a monitor in Amazon CloudWatch Internet Monitor\cr
\link[paws.management:cloudwatchinternetmonitor_delete_monitor]{delete_monitor} \tab Deletes a monitor in Amazon CloudWatch Internet Monitor\cr
\link[paws.management:cloudwatchinternetmonitor_get_health_event]{get_health_event} \tab Gets information that Amazon CloudWatch Internet Monitor has created and stored about a health event for a specified monitor\cr
\link[paws.management:cloudwatchinternetmonitor_get_internet_event]{get_internet_event} \tab Gets information that Amazon CloudWatch Internet Monitor has generated about an internet event\cr
\link[paws.management:cloudwatchinternetmonitor_get_monitor]{get_monitor} \tab Gets information about a monitor in Amazon CloudWatch Internet Monitor based on a monitor name\cr
\link[paws.management:cloudwatchinternetmonitor_get_query_results]{get_query_results} \tab Return the data for a query with the Amazon CloudWatch Internet Monitor query interface\cr
\link[paws.management:cloudwatchinternetmonitor_get_query_status]{get_query_status} \tab Returns the current status of a query for the Amazon CloudWatch Internet Monitor query interface, for a specified query ID and monitor\cr
\link[paws.management:cloudwatchinternetmonitor_list_health_events]{list_health_events} \tab Lists all health events for a monitor in Amazon CloudWatch Internet Monitor\cr
\link[paws.management:cloudwatchinternetmonitor_list_internet_events]{list_internet_events} \tab Lists internet events that cause performance or availability issues for client locations\cr
\link[paws.management:cloudwatchinternetmonitor_list_monitors]{list_monitors} \tab Lists all of your monitors for Amazon CloudWatch Internet Monitor and their statuses, along with the Amazon Resource Name (ARN) and name of each monitor\cr
\link[paws.management:cloudwatchinternetmonitor_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for a resource\cr
\link[paws.management:cloudwatchinternetmonitor_start_query]{start_query} \tab Start a query to return data for a specific query type for the Amazon CloudWatch Internet Monitor query interface\cr
\link[paws.management:cloudwatchinternetmonitor_stop_query]{stop_query} \tab Stop a query that is progress for a specific monitor\cr
\link[paws.management:cloudwatchinternetmonitor_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
\link[paws.management:cloudwatchinternetmonitor_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
\link[paws.management:cloudwatchinternetmonitor_update_monitor]{update_monitor} \tab Updates a monitor
}
}

\examples{
\dontrun{
svc <- cloudwatchinternetmonitor()
svc$create_monitor(
  Foo = 123
)
}

}
