% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_cond.r
\docType{methods}
\name{condnums}
\alias{condnums}
\alias{kappa.ddmatrix}
\alias{rcond,ddmatrix-method}
\title{Compute or estimate the Condition Number of a Distributed Matrix}
\usage{
\method{kappa}{ddmatrix}(z, exact = FALSE, norm = NULL, method = c("qr",
  "direct"), ...)

\S4method{rcond}{ddmatrix}(x, norm = c("O", "I", "1"), triangular = FALSE,
  ...)
}
\arguments{
\item{exact}{logical. Determines whether exact condition number or
approximation should be computed.}

\item{norm}{character. Determines which matrix norm is to be used.}

\item{method}{character. Determines the method use in computing condition
number.}

\item{...}{Extra arguments.}

\item{x, z}{numeric distributed matrices.}

\item{triangular}{logical. If true, only the lower triangle is used.}
}
\value{
Returns a number.
}
\description{
Computes or estimates the condition number.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

comm.set.seed(diff=T)
x <- ddmatrix("rnorm", 10, 10, bldim=2)

cn <- rcond(x)

comm.print(cn)

finalize()
}

}
\keyword{Algebra}
\keyword{ConditionNumbers}
\keyword{Linear}
\keyword{Methods}

