% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_[.r
\docType{methods}
\name{insert}
\alias{[<-,ddmatrix,ANY,ANY,ANY-method}
\alias{[<-,ddmatrix,ANY,ANY,ddmatrix-method}
\alias{insert}
\title{Directly Insert Into Distributed Matrix Submatrix Slot}
\usage{
\S4method{[}{ddmatrix,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{[}{ddmatrix,ANY,ANY,ddmatrix}(x, i, j, ...) <- value
}
\arguments{
\item{x}{numeric distributed matrix.}

\item{i, j}{global integer indices.}

\item{...}{Additional arguments.}

\item{value}{replacement value. Can be a global vector or a \code{ddmatrix}.}
}
\value{
Returns a distributed matrix.
}
\description{
Allows you to directly replace the submatrix of a distributed matrix.
}
\details{
\code{[<-} allows the user to insert values into a distributed matrix in
exactly the same way one would with an ordinary matrix. The indices here are
global, meaning that \code{x[i, j]} refers to the \code{(i, j)}'th element
of the "full", global matrix, and not necessarily the \code{(i, j)}'th
element of the local submatrix.

On the other hand, \code{submatrix<-} is different. It is basically
syntactic sugar for:

\code{x@Data <- newMatrix}

It does not alter the distributed matrix \code{x}'s \code{dim} or
\code{bldim}. It \emph{does} adjust the \code{ldim} automatically.  However,
using this can be dangerous. It is merely provided to give consistent
behavior with the \code{submatrix()} function.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:9, 3, bldim=2)

x[1, ] <- 0
comm.print(submatrix(x), all.rank=T)

finalize()
}

}
\keyword{Extraction}
\keyword{Methods}

