% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_get_dama_xml_details.R
\name{f_get_dama_xml_details}
\alias{f_get_dama_xml_details}
\title{Get Details of an '.xml' within 'DataMashup'}
\usage{
f_get_dama_xml_details(input_file_pbix)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}
}
\value{
A list containing [[1]] the length of each '.xml', [[2]] the first
400 bytes of each '.xml' converted to character and [[3]] the total length of
all '.xml' files.
}
\description{
The details of an '.xml' within 'DataMashup' are retrieved.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

# Run the function
test <- f_get_dama_xml_details(pathFileSample)
  }
}
\seealso{
Uses: \code{\link{f_get_dama_index}},
\code{\link{f_get_dama_file}},
}
\author{
Don Diproto
}
